/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.azure;

import com.azure.core.http.HttpClient;
import com.azure.core.http.okhttp.OkHttpAsyncClientProvider;
import com.azure.core.util.HttpClientOptions;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.airlift.units.DataSize;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.azure.AzureAuth;
import io.trino.filesystem.azure.AzureFileSystem;
import io.trino.filesystem.azure.AzureFileSystemConfig;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Objects;

public class AzureFileSystemFactory
implements TrinoFileSystemFactory {
    private final AzureAuth auth;
    private final DataSize readBlockSize;
    private final DataSize writeBlockSize;
    private final int maxWriteConcurrency;
    private final DataSize maxSingleUploadSize;
    private final HttpClient httpClient;

    @Inject
    public AzureFileSystemFactory(AzureAuth azureAuth, AzureFileSystemConfig config) {
        this(azureAuth, config.getReadBlockSize(), config.getWriteBlockSize(), config.getMaxWriteConcurrency(), config.getMaxSingleUploadSize());
    }

    public AzureFileSystemFactory(AzureAuth azureAuth, DataSize readBlockSize, DataSize writeBlockSize, int maxWriteConcurrency, DataSize maxSingleUploadSize) {
        this.auth = Objects.requireNonNull(azureAuth, "azureAuth is null");
        this.readBlockSize = Objects.requireNonNull(readBlockSize, "readBlockSize is null");
        this.writeBlockSize = Objects.requireNonNull(writeBlockSize, "writeBlockSize is null");
        Preconditions.checkArgument((maxWriteConcurrency >= 0 ? 1 : 0) != 0, (Object)"maxWriteConcurrency is negative");
        this.maxWriteConcurrency = maxWriteConcurrency;
        this.maxSingleUploadSize = Objects.requireNonNull(maxSingleUploadSize, "maxSingleUploadSize is null");
        this.httpClient = HttpClient.createDefault((HttpClientOptions)new HttpClientOptions().setHttpClientProvider(OkHttpAsyncClientProvider.class));
    }

    public TrinoFileSystem create(ConnectorIdentity identity) {
        return new AzureFileSystem(this.httpClient, this.auth, this.readBlockSize, this.writeBlockSize, this.maxWriteConcurrency, this.maxSingleUploadSize);
    }
}

