/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles;

import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.ItemsSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.ItemsUtil;
import java.util.Arrays;
import java.util.Comparator;

class ItemsPmfCdfImpl {
    ItemsPmfCdfImpl() {
    }

    static <T> double[] getPMFOrCDF(ItemsSketch<T> sketch, T[] splitPoints, boolean isCDF) {
        long[] counters = ItemsPmfCdfImpl.internalBuildHistogram(splitPoints, sketch);
        int numCounters = counters.length;
        double[] result = new double[numCounters];
        double n = sketch.getN();
        long subtotal = 0L;
        if (isCDF) {
            for (int j = 0; j < numCounters; ++j) {
                long count = counters[j];
                result[j] = (double)(subtotal += count) / n;
            }
        } else {
            for (int j = 0; j < numCounters; ++j) {
                long count = counters[j];
                subtotal += count;
                result[j] = (double)count / n;
            }
        }
        assert ((double)subtotal == n);
        return result;
    }

    private static <T> long[] internalBuildHistogram(T[] splitPoints, ItemsSketch<T> sketch) {
        long myBitPattern;
        Object[] levelsArr;
        Object[] baseBuffer = levelsArr = sketch.getCombinedBuffer();
        int bbCount = sketch.getBaseBufferCount();
        ItemsUtil.validateValues(splitPoints, sketch.getComparator());
        int numSplitPoints = splitPoints.length;
        int numCounters = numSplitPoints + 1;
        long[] counters = new long[numCounters];
        long weight = 1L;
        if (numSplitPoints < 50) {
            ItemsPmfCdfImpl.bilinearTimeIncrementHistogramCounters(baseBuffer, 0, bbCount, weight, splitPoints, counters, sketch.getComparator());
        } else {
            Arrays.sort(baseBuffer, 0, bbCount);
            ItemsPmfCdfImpl.linearTimeIncrementHistogramCounters(baseBuffer, 0, bbCount, weight, splitPoints, counters, sketch.getComparator());
        }
        int k = sketch.getK();
        assert (myBitPattern == sketch.getN() / (2L * (long)k));
        int lvl = 0;
        for (myBitPattern = sketch.getBitPattern(); myBitPattern != 0L; myBitPattern >>>= 1) {
            weight += weight;
            if ((myBitPattern & 1L) > 0L) {
                ItemsPmfCdfImpl.linearTimeIncrementHistogramCounters(levelsArr, (2 + lvl) * k, k, weight, splitPoints, counters, sketch.getComparator());
            }
            ++lvl;
        }
        return counters;
    }

    private static <T> void bilinearTimeIncrementHistogramCounters(T[] samples, int offset, int numSamples, long weight, T[] splitPoints, long[] counters, Comparator<? super T> comparator) {
        assert (splitPoints.length + 1 == counters.length);
        for (int i = 0; i < numSamples; ++i) {
            T splitpoint;
            T sample = samples[i + offset];
            int j = 0;
            for (j = 0; j < splitPoints.length && comparator.compare(sample, splitpoint = splitPoints[j]) >= 0; ++j) {
            }
            assert (j < counters.length);
            int n = j;
            counters[n] = counters[n] + weight;
        }
    }

    private static <T> void linearTimeIncrementHistogramCounters(T[] samples, int offset, int numSamples, long weight, T[] splitPoints, long[] counters, Comparator<? super T> comparator) {
        int i = 0;
        int j = 0;
        while (i < numSamples && j < splitPoints.length) {
            if (comparator.compare(samples[i + offset], splitPoints[j]) < 0) {
                int n = j;
                counters[n] = counters[n] + weight;
                ++i;
                continue;
            }
            ++j;
        }
        if (j == splitPoints.length) {
            int n = j;
            counters[n] = counters[n] + weight * (long)(numSamples - i);
        }
    }
}

