/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.org.codehaus.janino.samples;

import com.linkedin.coral.calcite.;
import com.linkedin.coral.calcite.$internal.org.codehaus.commons.compiler.CompileException;
import com.linkedin.coral.calcite.$internal.org.codehaus.janino.Parser;
import com.linkedin.coral.calcite.$internal.org.codehaus.janino.Scanner;
import com.linkedin.coral.calcite.$internal.org.codehaus.janino.util.AbstractTraverser;
import java.io.FileReader;
import java.io.IOException;

public class DeclarationCounter
extends AbstractTraverser<RuntimeException> {
    private int classDeclarationCount;
    private int interfaceDeclarationCount;
    private int fieldCount;
    private int localVariableCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws CompileException, IOException {
        DeclarationCounter dc = new DeclarationCounter();
        for (String fileName : args) {
            .Java.CompilationUnit cu;
            FileReader r = new FileReader(fileName);
            try {
                cu = new Parser(new Scanner(fileName, r)).parseCompilationUnit();
            }
            finally {
                r.close();
            }
            dc.traverseCompilationUnit(cu);
        }
        System.out.println("Class declarations:     " + dc.classDeclarationCount);
        System.out.println("Interface declarations: " + dc.interfaceDeclarationCount);
        System.out.println("Fields:                 " + dc.fieldCount);
        System.out.println("Local variables:        " + dc.localVariableCount);
    }

    @Override
    public void traverseClassDeclaration(.Java.AbstractClassDeclaration cd2) {
        ++this.classDeclarationCount;
        super.traverseClassDeclaration(cd2);
    }

    @Override
    public void traverseInterfaceDeclaration(.Java.InterfaceDeclaration id) {
        ++this.interfaceDeclarationCount;
        super.traverseInterfaceDeclaration(id);
    }

    @Override
    public void traverseFieldDeclaration(.Java.FieldDeclaration fd) {
        this.fieldCount += fd.variableDeclarators.length;
        super.traverseFieldDeclaration(fd);
    }

    @Override
    public void traverseLocalVariableDeclarationStatement(.Java.LocalVariableDeclarationStatement lvds) {
        this.localVariableCount += lvds.variableDeclarators.length;
        super.traverseLocalVariableDeclarationStatement(lvds);
    }
}

