/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import com.linkedin.coral.calcite.$internal.com.google.common.collect.ImmutableMap;
import com.linkedin.coral.calcite.$internal.com.google.common.collect.ImmutableSet;
import com.linkedin.coral.calcite.$internal.com.google.common.collect.Sets;
import java.util.Set;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.Pair;

public class RexFieldCollation
extends Pair<RexNode, ImmutableSet<SqlKind>> {
    private static final ImmutableMap<Set<SqlKind>, ImmutableSet<SqlKind>> KINDS = new Initializer().add().add(SqlKind.NULLS_FIRST, new SqlKind[0]).add(SqlKind.NULLS_LAST, new SqlKind[0]).add(SqlKind.DESCENDING, new SqlKind[0]).add(SqlKind.DESCENDING, SqlKind.NULLS_FIRST).add(SqlKind.DESCENDING, SqlKind.NULLS_LAST).build();

    public RexFieldCollation(RexNode left, Set<SqlKind> right) {
        super(left, KINDS.get(right));
    }

    @Override
    public String toString() {
        String s2 = ((RexNode)this.left).toString();
        if (((ImmutableSet)this.right).isEmpty()) {
            return s2;
        }
        StringBuilder b = new StringBuilder(s2);
        block5: for (SqlKind operator : (ImmutableSet)this.right) {
            switch (operator) {
                case DESCENDING: {
                    b.append(" DESC");
                    continue block5;
                }
                case NULLS_FIRST: {
                    b.append(" NULLS FIRST");
                    continue block5;
                }
                case NULLS_LAST: {
                    b.append(" NULLS LAST");
                    continue block5;
                }
            }
            throw new AssertionError((Object)operator);
        }
        return b.toString();
    }

    public RelFieldCollation.Direction getDirection() {
        return ((ImmutableSet)this.right).contains((Object)SqlKind.DESCENDING) ? RelFieldCollation.Direction.DESCENDING : RelFieldCollation.Direction.ASCENDING;
    }

    public RelFieldCollation.NullDirection getNullDirection() {
        return ((ImmutableSet)this.right).contains((Object)SqlKind.NULLS_LAST) ? RelFieldCollation.NullDirection.LAST : (((ImmutableSet)this.right).contains((Object)SqlKind.NULLS_FIRST) ? RelFieldCollation.NullDirection.FIRST : this.getDirection().defaultNullDirection());
    }

    private static class Initializer {
        final ImmutableMap.Builder<Set<SqlKind>, ImmutableSet<SqlKind>> builder = ImmutableMap.builder();

        private Initializer() {
        }

        public Initializer add() {
            return this.add(ImmutableSet.of());
        }

        public Initializer add(SqlKind kind, SqlKind ... kinds) {
            return this.add(Sets.immutableEnumSet((Enum)kind, (Enum[])kinds));
        }

        private Initializer add(ImmutableSet<SqlKind> set) {
            this.builder.put(set, set);
            return this;
        }

        public ImmutableMap<Set<SqlKind>, ImmutableSet<SqlKind>> build() {
            return this.builder.build();
        }
    }
}

