/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.oauth2;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.oauth2.IdentityTransformer;
import org.apache.hadoop.fs.azurebfs.utils.IdentityHandler;
import org.apache.hadoop.fs.azurebfs.utils.TextFileBasedIdentityHandler;

public class LocalIdentityTransformer
extends IdentityTransformer {
    private static final Logger LOG = LoggerFactory.getLogger(LocalIdentityTransformer.class);
    private IdentityHandler localToAadIdentityLookup;

    public LocalIdentityTransformer(Configuration configuration) throws IOException {
        super(configuration);
        this.localToAadIdentityLookup = new TextFileBasedIdentityHandler(configuration.get("fs.azure.identity.transformer.local.service.principal.mapping.file.path"), configuration.get("fs.azure.identity.transformer.local.service.group.mapping.file.path"));
    }

    @Override
    public String transformIdentityForGetRequest(String originalIdentity, boolean isUserName, String localIdentity) throws IOException {
        String localIdentityForOrig;
        String string = localIdentityForOrig = isUserName ? this.localToAadIdentityLookup.lookupForLocalUserIdentity(originalIdentity) : this.localToAadIdentityLookup.lookupForLocalGroupIdentity(originalIdentity);
        if (localIdentityForOrig == null || localIdentityForOrig.isEmpty()) {
            return super.transformIdentityForGetRequest(originalIdentity, isUserName, localIdentity);
        }
        return localIdentityForOrig;
    }
}

