/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.avro;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.hive.formats.avro.AvroTypeException;
import io.trino.hive.formats.avro.AvroTypeManager;
import io.trino.hive.formats.avro.AvroTypeUtils;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.SqlMap;
import io.trino.spi.block.SqlRow;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import java.util.function.ToIntBiFunction;
import java.util.function.ToLongBiFunction;
import java.util.stream.IntStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;

public class AvroPagePositionDataWriter
implements DatumWriter<Integer> {
    private Page page;
    private final Schema schema;
    private final RecordBlockPositionEncoder pageBlockPositionEncoder;

    public AvroPagePositionDataWriter(Schema schema, AvroTypeManager avroTypeManager, List<String> channelNames, List<Type> channelTypes) throws AvroTypeException {
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.pageBlockPositionEncoder = new RecordBlockPositionEncoder(schema, avroTypeManager, channelNames, channelTypes);
        this.checkInvariants();
    }

    public void setSchema(Schema schema) {
        Objects.requireNonNull(schema, "schema is null");
        if (this.schema != schema) {
            Verify.verify((boolean)this.schema.equals((Object)AvroTypeUtils.lowerCaseAllFieldsForWriter(schema)), (String)"Unable to change schema for this data writer", (Object[])new Object[0]);
        }
    }

    public void setPage(Page page) {
        this.page = Objects.requireNonNull(page, "page is null");
        this.checkInvariants();
        this.pageBlockPositionEncoder.setChannelBlocksFromPage(page);
    }

    private void checkInvariants() {
        Verify.verify((this.schema.getType() == Schema.Type.RECORD ? 1 : 0) != 0, (String)"Can only write pages to record schema", (Object[])new Object[0]);
        Verify.verify((this.page == null || this.page.getChannelCount() == this.schema.getFields().size() ? 1 : 0) != 0, (String)"Page channel count must equal schema field count", (Object[])new Object[0]);
    }

    public void write(Integer position, Encoder encoder) throws IOException {
        this.checkWritable();
        if (position >= this.page.getPositionCount()) {
            throw new IndexOutOfBoundsException("Position %s not within page with position count %s".formatted(position, this.page.getPositionCount()));
        }
        this.pageBlockPositionEncoder.encodePositionInEachChannel(position, encoder);
    }

    private void checkWritable() {
        Preconditions.checkState((this.page != null ? 1 : 0) != 0, (Object)"page must be set before beginning to write positions");
    }

    private static BlockPositionEncoder createBlockPositionEncoder(Schema schema, AvroTypeManager avroTypeManager, Type type) throws AvroTypeException {
        return AvroPagePositionDataWriter.createBlockPositionEncoder(schema, avroTypeManager, type, Optional.empty());
    }

    private static BlockPositionEncoder createBlockPositionEncoder(Schema schema, AvroTypeManager avroTypeManager, Type type, Optional<AvroTypeUtils.SimpleUnionNullIndex> nullIdx) throws AvroTypeException {
        Optional<BiFunction<Block, Integer, Object>> overrideToAvroGenericObject = avroTypeManager.overrideBlockToAvroObject(schema, type);
        if (overrideToAvroGenericObject.isPresent()) {
            return new UserDefinedBlockPositionEncoder(nullIdx, schema, overrideToAvroGenericObject.get());
        }
        switch (schema.getType()) {
            case NULL: {
                throw new AvroTypeException("No null support outside of union");
            }
            case BOOLEAN: {
                if (!BooleanType.BOOLEAN.equals((Object)type)) break;
                return new BooleanBlockPositionEncoder(nullIdx);
            }
            case INT: {
                if (TinyintType.TINYINT.equals((Object)type)) {
                    return new IntBlockPositionEncoder(nullIdx, (arg_0, arg_1) -> ((TinyintType)TinyintType.TINYINT).getByte(arg_0, arg_1));
                }
                if (SmallintType.SMALLINT.equals((Object)type)) {
                    return new IntBlockPositionEncoder(nullIdx, (arg_0, arg_1) -> ((SmallintType)SmallintType.SMALLINT).getShort(arg_0, arg_1));
                }
                if (!IntegerType.INTEGER.equals((Object)type)) break;
                return new IntBlockPositionEncoder(nullIdx, (arg_0, arg_1) -> ((IntegerType)IntegerType.INTEGER).getInt(arg_0, arg_1));
            }
            case LONG: {
                if (TinyintType.TINYINT.equals((Object)type)) {
                    return new LongBlockPositionEncoder(nullIdx, (arg_0, arg_1) -> ((TinyintType)TinyintType.TINYINT).getByte(arg_0, arg_1));
                }
                if (SmallintType.SMALLINT.equals((Object)type)) {
                    return new LongBlockPositionEncoder(nullIdx, (arg_0, arg_1) -> ((SmallintType)SmallintType.SMALLINT).getShort(arg_0, arg_1));
                }
                if (IntegerType.INTEGER.equals((Object)type)) {
                    return new LongBlockPositionEncoder(nullIdx, (arg_0, arg_1) -> ((IntegerType)IntegerType.INTEGER).getInt(arg_0, arg_1));
                }
                if (!BigintType.BIGINT.equals((Object)type)) break;
                return new LongBlockPositionEncoder(nullIdx, (arg_0, arg_1) -> ((BigintType)BigintType.BIGINT).getLong(arg_0, arg_1));
            }
            case FLOAT: {
                if (!RealType.REAL.equals((Object)type)) break;
                return new FloatBlockPositionEncoder(nullIdx);
            }
            case DOUBLE: {
                if (!DoubleType.DOUBLE.equals((Object)type)) break;
                return new DoubleBlockPositionEncoder(nullIdx);
            }
            case STRING: {
                if (!VarcharType.VARCHAR.equals((Object)type)) break;
                return new StringOrBytesPositionEncoder(nullIdx);
            }
            case BYTES: {
                if (!VarbinaryType.VARBINARY.equals((Object)type)) break;
                return new StringOrBytesPositionEncoder(nullIdx);
            }
            case FIXED: {
                if (!VarbinaryType.VARBINARY.equals((Object)type)) break;
                return new FixedBlockPositionEncoder(nullIdx, schema.getFixedSize());
            }
            case ENUM: {
                if (!VarcharType.VARCHAR.equals((Object)type)) break;
                return new EnumBlockPositionEncoder(nullIdx, schema.getEnumSymbols());
            }
            case ARRAY: {
                if (!(type instanceof ArrayType)) break;
                ArrayType arrayType = (ArrayType)type;
                return new ArrayBlockPositionEncoder(nullIdx, schema, avroTypeManager, arrayType);
            }
            case MAP: {
                if (!(type instanceof MapType)) break;
                MapType mapType = (MapType)type;
                return new MapBlockPositionEncoder(nullIdx, schema, avroTypeManager, mapType);
            }
            case RECORD: {
                if (!(type instanceof RowType)) break;
                RowType rowType = (RowType)type;
                return new RecordBlockPositionEncoder(nullIdx, schema, avroTypeManager, rowType);
            }
            case UNION: {
                if (AvroTypeUtils.isSimpleNullableUnion(schema)) {
                    return AvroPagePositionDataWriter.createBlockPositionEncoder(AvroTypeUtils.unwrapNullableUnion(schema), avroTypeManager, type, Optional.of(AvroTypeUtils.getSimpleNullableUnionNullIndex(schema)));
                }
                throw new AvroTypeException("Unable to make writer for schema with non simple nullable union %s".formatted(schema));
            }
        }
        throw new AvroTypeException("Schema and Trino Type mismatch between %s and %s".formatted(schema, type));
    }

    private static class RecordBlockPositionEncoder
    extends BlockPositionEncoder {
        private final RowType type;
        private final BlockPositionEncoder[] channelEncoders;
        private final int[] fieldToChannel;

        public RecordBlockPositionEncoder(Optional<AvroTypeUtils.SimpleUnionNullIndex> nullIdx, Schema schema, AvroTypeManager avroTypeManager, RowType rowType) throws AvroTypeException {
            this(nullIdx, schema, avroTypeManager, (List)rowType.getFields().stream().map(RowType.Field::getName).map(optName -> (String)optName.orElseThrow(() -> new IllegalArgumentException("Unable to use nested anonymous row type for avro writing"))).collect(ImmutableList.toImmutableList()), (List)rowType.getFields().stream().map(RowType.Field::getType).collect(ImmutableList.toImmutableList()));
        }

        public RecordBlockPositionEncoder(Schema schema, AvroTypeManager avroTypeManager, List<String> channelNames, List<Type> channelTypes) throws AvroTypeException {
            this(Optional.empty(), schema, avroTypeManager, channelNames, channelTypes);
        }

        private RecordBlockPositionEncoder(Optional<AvroTypeUtils.SimpleUnionNullIndex> nullIdx, Schema schema, AvroTypeManager avroTypeManager, List<String> channelNames, List<Type> channelTypes) throws AvroTypeException {
            super(nullIdx);
            this.type = RowType.anonymous(Objects.requireNonNull(channelTypes, "channelTypes is null"));
            Verify.verify((Objects.requireNonNull(schema, "schema is null").getType() == Schema.Type.RECORD ? 1 : 0) != 0);
            Verify.verify((schema.getFields().size() == channelTypes.size() ? 1 : 0) != 0, (String)"Must have channel for each record field", (Object[])new Object[0]);
            Verify.verify((Objects.requireNonNull(channelNames, "channelNames is null").size() == channelTypes.size() ? 1 : 0) != 0, (String)"Must provide names for all channels", (Object[])new Object[0]);
            this.fieldToChannel = new int[schema.getFields().size()];
            this.channelEncoders = new BlockPositionEncoder[schema.getFields().size()];
            for (int i = 0; i < channelNames.size(); ++i) {
                String fieldName = channelNames.get(i);
                Schema.Field avroField = Objects.requireNonNull(schema.getField(fieldName), "no field with name %s in schema %s".formatted(fieldName, schema));
                this.fieldToChannel[avroField.pos()] = i;
                this.channelEncoders[i] = AvroPagePositionDataWriter.createBlockPositionEncoder(avroField.schema(), avroTypeManager, channelTypes.get(i));
            }
            Verify.verify((IntStream.of(this.fieldToChannel).sum() == schema.getFields().size() * (schema.getFields().size() - 1) / 2 ? 1 : 0) != 0, (String)"all channels must be accounted for", (Object[])new Object[0]);
        }

        @Override
        void encodeFromBlock(int position, Encoder encoder) throws IOException {
            SqlRow sqlRow = this.type.getObject(this.block, position);
            for (int i2 = 0; i2 < this.channelEncoders.length; ++i2) {
                this.channelEncoders[i2].setBlock(sqlRow.getRawFieldBlock(i2));
            }
            int rawIndex = sqlRow.getRawIndex();
            this.encodeInternal(i -> rawIndex, encoder);
        }

        public void setChannelBlocksFromPage(Page page) {
            Verify.verify((page.getChannelCount() == this.channelEncoders.length ? 1 : 0) != 0, (String)"Page must have channels equal to provided type list", (Object[])new Object[0]);
            for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                this.channelEncoders[channel].setBlock(page.getBlock(channel));
            }
        }

        public void encodePositionInEachChannel(int position, Encoder encoder) throws IOException {
            this.encodeInternal(ignore -> position, encoder);
        }

        private void encodeInternal(IntFunction<Integer> channelToPosition, Encoder encoder) throws IOException {
            for (int channel : this.fieldToChannel) {
                BlockPositionEncoder channelEncoder = this.channelEncoders[channel];
                channelEncoder.encode(channelToPosition.apply(channel), encoder);
            }
        }
    }

    private static abstract class BlockPositionEncoder {
        protected Block block;
        private final Optional<AvroTypeUtils.SimpleUnionNullIndex> nullIndex;

        public BlockPositionEncoder(Optional<AvroTypeUtils.SimpleUnionNullIndex> nullIndex) {
            this.nullIndex = Objects.requireNonNull(nullIndex, "nullIdx is null");
        }

        abstract void encodeFromBlock(int var1, Encoder var2) throws IOException;

        void encode(int position, Encoder encoder) throws IOException {
            Preconditions.checkState((this.block != null ? 1 : 0) != 0, (Object)"block must be set before calling encode");
            boolean isNull = this.block.isNull(position);
            if (isNull && this.nullIndex.isEmpty()) {
                throw new IOException("Can not write null value for non-nullable schema");
            }
            if (this.nullIndex.isPresent()) {
                encoder.writeIndex(isNull ? this.nullIndex.get().getIndex() : 1 ^ this.nullIndex.get().getIndex());
            }
            if (isNull) {
                encoder.writeNull();
            } else {
                this.encodeFromBlock(position, encoder);
            }
        }

        void setBlock(Block block) {
            this.block = block;
        }
    }

    private static class UserDefinedBlockPositionEncoder
    extends BlockPositionEncoder {
        private final GenericDatumWriter<Object> datumWriter;
        private final BiFunction<Block, Integer, Object> toAvroGeneric;

        public UserDefinedBlockPositionEncoder(Optional<AvroTypeUtils.SimpleUnionNullIndex> nullIdx, Schema schema, BiFunction<Block, Integer, Object> toAvroGeneric) {
            super(nullIdx);
            this.datumWriter = new GenericDatumWriter(Objects.requireNonNull(schema, "schema is null"));
            this.toAvroGeneric = Objects.requireNonNull(toAvroGeneric, "toAvroGeneric is null");
        }

        @Override
        void encodeFromBlock(int position, Encoder encoder) throws IOException {
            this.datumWriter.write(this.toAvroGeneric.apply(this.block, position), encoder);
        }
    }

    private static class BooleanBlockPositionEncoder
    extends BlockPositionEncoder {
        public BooleanBlockPositionEncoder(Optional<AvroTypeUtils.SimpleUnionNullIndex> isNullWithIndex) {
            super(isNullWithIndex);
        }

        @Override
        void encodeFromBlock(int position, Encoder encoder) throws IOException {
            encoder.writeBoolean(BooleanType.BOOLEAN.getBoolean(this.block, position));
        }
    }

    private static class IntBlockPositionEncoder
    extends BlockPositionEncoder {
        private final ToIntBiFunction<Block, Integer> getInt;

        public IntBlockPositionEncoder(Optional<AvroTypeUtils.SimpleUnionNullIndex> isNullWithIndex, ToIntBiFunction<Block, Integer> getInt) {
            super(isNullWithIndex);
            this.getInt = Objects.requireNonNull(getInt, "getInt is null");
        }

        @Override
        void encodeFromBlock(int position, Encoder encoder) throws IOException {
            encoder.writeInt(this.getInt.applyAsInt(this.block, position));
        }
    }

    private static class LongBlockPositionEncoder
    extends BlockPositionEncoder {
        private final ToLongBiFunction<Block, Integer> getLong;

        public LongBlockPositionEncoder(Optional<AvroTypeUtils.SimpleUnionNullIndex> isNullWithIndex, ToLongBiFunction<Block, Integer> getLong) {
            super(isNullWithIndex);
            this.getLong = Objects.requireNonNull(getLong, "getLong is null");
        }

        @Override
        void encodeFromBlock(int position, Encoder encoder) throws IOException {
            encoder.writeLong(this.getLong.applyAsLong(this.block, position));
        }
    }

    private static class FloatBlockPositionEncoder
    extends BlockPositionEncoder {
        public FloatBlockPositionEncoder(Optional<AvroTypeUtils.SimpleUnionNullIndex> isNullWithIndex) {
            super(isNullWithIndex);
        }

        @Override
        void encodeFromBlock(int position, Encoder encoder) throws IOException {
            encoder.writeFloat(RealType.REAL.getFloat(this.block, position));
        }
    }

    private static class DoubleBlockPositionEncoder
    extends BlockPositionEncoder {
        public DoubleBlockPositionEncoder(Optional<AvroTypeUtils.SimpleUnionNullIndex> isNullWithIndex) {
            super(isNullWithIndex);
        }

        @Override
        void encodeFromBlock(int position, Encoder encoder) throws IOException {
            encoder.writeDouble(DoubleType.DOUBLE.getDouble(this.block, position));
        }
    }

    private static class StringOrBytesPositionEncoder
    extends BlockPositionEncoder {
        public StringOrBytesPositionEncoder(Optional<AvroTypeUtils.SimpleUnionNullIndex> isNullWithIndex) {
            super(isNullWithIndex);
        }

        @Override
        void encodeFromBlock(int position, Encoder encoder) throws IOException {
            int length = this.block.getSliceLength(position);
            encoder.writeLong((long)length);
            encoder.writeFixed(this.block.getSlice(position, 0, length).getBytes());
        }
    }

    private static class FixedBlockPositionEncoder
    extends BlockPositionEncoder {
        private final int fixedSize;

        public FixedBlockPositionEncoder(Optional<AvroTypeUtils.SimpleUnionNullIndex> nullIdx, int fixedSize) {
            super(nullIdx);
            this.fixedSize = fixedSize;
        }

        @Override
        void encodeFromBlock(int position, Encoder encoder) throws IOException {
            int length = this.block.getSliceLength(position);
            if (length != this.fixedSize) {
                throw new IOException("Unable to write Avro fixed with size %s from slice of length %s".formatted(this.fixedSize, length));
            }
            encoder.writeFixed(this.block.getSlice(position, 0, length).getBytes());
        }
    }

    private static class EnumBlockPositionEncoder
    extends BlockPositionEncoder {
        private final Map<Slice, Integer> symbolToIndex;

        public EnumBlockPositionEncoder(Optional<AvroTypeUtils.SimpleUnionNullIndex> nullIdx, List<String> symbols) {
            super(nullIdx);
            ImmutableMap.Builder symbolToIndex = ImmutableMap.builder();
            for (int i = 0; i < symbols.size(); ++i) {
                symbolToIndex.put((Object)Slices.utf8Slice((String)symbols.get(i)), (Object)i);
            }
            this.symbolToIndex = symbolToIndex.buildOrThrow();
        }

        @Override
        void encodeFromBlock(int position, Encoder encoder) throws IOException {
            int length = this.block.getSliceLength(position);
            Integer symbolIndex = this.symbolToIndex.get(this.block.getSlice(position, 0, length));
            if (symbolIndex == null) {
                throw new IOException("Unable to write Avro Enum symbol %s. Not found in set %s".formatted(this.block.getSlice(position, 0, length).toStringUtf8(), this.symbolToIndex.keySet().stream().map(Slice::toStringUtf8).toList()));
            }
            encoder.writeEnum(symbolIndex.intValue());
        }
    }

    private static class ArrayBlockPositionEncoder
    extends BlockPositionEncoder {
        private final BlockPositionEncoder elementBlockPositionEncoder;
        private final ArrayType type;

        public ArrayBlockPositionEncoder(Optional<AvroTypeUtils.SimpleUnionNullIndex> nullIdx, Schema schema, AvroTypeManager avroTypeManager, ArrayType type) throws AvroTypeException {
            super(nullIdx);
            Verify.verify((Objects.requireNonNull(schema, "schema is null").getType() == Schema.Type.ARRAY ? 1 : 0) != 0);
            this.type = Objects.requireNonNull(type, "type is null");
            this.elementBlockPositionEncoder = AvroPagePositionDataWriter.createBlockPositionEncoder(schema.getElementType(), avroTypeManager, type.getElementType());
        }

        @Override
        void encodeFromBlock(int position, Encoder encoder) throws IOException {
            Block elementBlock = this.type.getObject(this.block, position);
            this.elementBlockPositionEncoder.setBlock(elementBlock);
            int size = elementBlock.getPositionCount();
            encoder.writeArrayStart();
            encoder.setItemCount((long)size);
            for (int itemPos = 0; itemPos < size; ++itemPos) {
                encoder.startItem();
                this.elementBlockPositionEncoder.encode(itemPos, encoder);
            }
            encoder.writeArrayEnd();
        }
    }

    private static class MapBlockPositionEncoder
    extends BlockPositionEncoder {
        private final BlockPositionEncoder keyBlockPositionEncoder = new StringOrBytesPositionEncoder(Optional.empty());
        private final BlockPositionEncoder valueBlockPositionEncoder;
        private final MapType type;

        public MapBlockPositionEncoder(Optional<AvroTypeUtils.SimpleUnionNullIndex> nullIdx, Schema schema, AvroTypeManager avroTypeManager, MapType type) throws AvroTypeException {
            super(nullIdx);
            Verify.verify((Objects.requireNonNull(schema, "schema is null").getType() == Schema.Type.MAP ? 1 : 0) != 0);
            this.type = Objects.requireNonNull(type, "type is null");
            if (!VarcharType.VARCHAR.equals((Object)this.type.getKeyType())) {
                throw new AvroTypeException("Avro Maps must have String keys, invalid type: %s".formatted(this.type.getKeyType()));
            }
            this.valueBlockPositionEncoder = AvroPagePositionDataWriter.createBlockPositionEncoder(schema.getValueType(), avroTypeManager, type.getValueType());
        }

        @Override
        void encodeFromBlock(int position, Encoder encoder) throws IOException {
            SqlMap sqlMap = this.type.getObject(this.block, position);
            this.keyBlockPositionEncoder.setBlock(sqlMap.getRawKeyBlock());
            this.valueBlockPositionEncoder.setBlock(sqlMap.getRawValueBlock());
            encoder.writeMapStart();
            encoder.setItemCount((long)sqlMap.getSize());
            int rawOffset = sqlMap.getRawOffset();
            for (int i = 0; i < sqlMap.getSize(); ++i) {
                encoder.startItem();
                this.keyBlockPositionEncoder.encode(rawOffset + i, encoder);
                this.valueBlockPositionEncoder.encode(rawOffset + i, encoder);
            }
            encoder.writeMapEnd();
        }
    }
}

