/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy;

import com.linkedin.coral.$internal.org.apache.hadoop.hive.common.type.Date;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.io.DateWritableV2;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyDateObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.io.Text;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyDate
extends LazyPrimitive<LazyDateObjectInspector, DateWritableV2> {
    private static final Logger LOG = LoggerFactory.getLogger(LazyDate.class);

    public LazyDate(LazyDateObjectInspector oi) {
        super(oi);
        this.data = new DateWritableV2();
    }

    public LazyDate(LazyDate copy) {
        super(copy);
        this.data = new DateWritableV2((DateWritableV2)copy.data);
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        String s2 = null;
        if (!LazyUtils.isDateMaybe(bytes.getData(), start, length)) {
            this.isNull = true;
            return;
        }
        try {
            s2 = Text.decode(bytes.getData(), start, length);
            ((DateWritableV2)this.data).set(Date.valueOf(s2));
            this.isNull = false;
        }
        catch (Exception e) {
            this.isNull = true;
            this.logExceptionMessage(bytes, start, length, "DATE");
        }
    }

    public static void writeUTF8(OutputStream out, DateWritableV2 d) throws IOException {
        ByteBuffer b = Text.encode(d.toString());
        out.write(b.array(), 0, b.limit());
    }
}

