/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles;

import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.DoublesSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.DoublesSketchAccessor;
import java.util.Arrays;

final class DoublesAuxiliary {
    long auxN_;
    double[] auxSamplesArr_;
    long[] auxCumWtsArr_;

    DoublesAuxiliary(DoublesSketch qs) {
        int k = qs.getK();
        long n = qs.getN();
        long bitPattern = qs.getBitPattern();
        int numSamples = qs.getRetainedItems();
        DoublesSketchAccessor sketchAccessor = DoublesSketchAccessor.wrap(qs);
        double[] itemsArr = new double[numSamples];
        long[] cumWtsArr = new long[numSamples + 1];
        DoublesAuxiliary.populateFromDoublesSketch(k, n, bitPattern, sketchAccessor, itemsArr, cumWtsArr);
        DoublesAuxiliary.blockyTandemMergeSort(itemsArr, cumWtsArr, numSamples, k);
        long subtot = 0L;
        for (int i = 0; i < numSamples + 1; ++i) {
            long newSubtot = subtot + cumWtsArr[i];
            cumWtsArr[i] = subtot;
            subtot = newSubtot;
        }
        assert (subtot == n);
        this.auxN_ = n;
        this.auxSamplesArr_ = itemsArr;
        this.auxCumWtsArr_ = cumWtsArr;
    }

    double getQuantile(double phi) {
        assert (0.0 <= phi);
        assert (phi <= 1.0);
        long n = this.auxN_;
        if (n <= 0L) {
            return Double.NaN;
        }
        long pos = DoublesAuxiliary.posOfPhi(phi, n);
        return this.approximatelyAnswerPositionalQuery(pos);
    }

    static long posOfPhi(double phi, long n) {
        long pos = (long)Math.floor(phi * (double)n);
        return pos == n ? n - 1L : pos;
    }

    private double approximatelyAnswerPositionalQuery(long pos) {
        assert (0L <= pos);
        assert (pos < this.auxN_);
        int index = DoublesAuxiliary.chunkContainingPos(this.auxCumWtsArr_, pos);
        return this.auxSamplesArr_[index];
    }

    private static final void populateFromDoublesSketch(int k, long n, long bitPattern, DoublesSketchAccessor sketchAccessor, double[] itemsArr, long[] cumWtsArr) {
        int i;
        long bits;
        long weight = 1L;
        int nxt = 0;
        assert (bits == n / (2L * (long)k));
        int lvl = 0;
        for (bits = bitPattern; bits != 0L; bits >>>= 1) {
            weight *= 2L;
            if ((bits & 1L) > 0L) {
                sketchAccessor.setLevel(lvl);
                for (i = 0; i < sketchAccessor.numItems(); ++i) {
                    itemsArr[nxt] = sketchAccessor.get(i);
                    cumWtsArr[nxt] = weight;
                    ++nxt;
                }
            }
            ++lvl;
        }
        weight = 1L;
        int startOfBaseBufferBlock = nxt;
        sketchAccessor.setLevel(-1);
        for (i = 0; i < sketchAccessor.numItems(); ++i) {
            itemsArr[nxt] = sketchAccessor.get(i);
            cumWtsArr[nxt] = weight;
            ++nxt;
        }
        assert (nxt == itemsArr.length);
        int numSamples = nxt;
        Arrays.sort(itemsArr, startOfBaseBufferBlock, numSamples);
        cumWtsArr[numSamples] = 0L;
    }

    static int chunkContainingPos(long[] arr, long pos) {
        int nominalLength = arr.length - 1;
        assert (nominalLength > 0);
        long n = arr[nominalLength];
        assert (0L <= pos);
        assert (pos < n);
        boolean l = false;
        int r = nominalLength;
        assert (0 < r);
        assert (arr[0] <= pos);
        assert (pos < arr[r]);
        return DoublesAuxiliary.searchForChunkContainingPos(arr, pos, 0, r);
    }

    private static int searchForChunkContainingPos(long[] arr, long pos, int l, int r) {
        assert (l < r);
        assert (arr[l] <= pos);
        assert (pos < arr[r]);
        if (l + 1 == r) {
            return l;
        }
        int m3 = l + (r - l) / 2;
        if (arr[m3] <= pos) {
            return DoublesAuxiliary.searchForChunkContainingPos(arr, pos, m3, r);
        }
        return DoublesAuxiliary.searchForChunkContainingPos(arr, pos, l, m3);
    }

    static void blockyTandemMergeSort(double[] keyArr, long[] valArr, int arrLen, int blkSize) {
        assert (blkSize >= 1);
        if (arrLen <= blkSize) {
            return;
        }
        int numblks = arrLen / blkSize;
        if (numblks * blkSize < arrLen) {
            ++numblks;
        }
        assert (numblks * blkSize >= arrLen);
        double[] keyTmp = Arrays.copyOf(keyArr, arrLen);
        long[] valTmp = Arrays.copyOf(valArr, arrLen);
        DoublesAuxiliary.blockyTandemMergeSortRecursion(keyTmp, valTmp, keyArr, valArr, 0, numblks, blkSize, arrLen);
    }

    private static void blockyTandemMergeSortRecursion(double[] keySrc, long[] valSrc, double[] keyDst, long[] valDst, int grpStart, int grpLen, int blkSize, int arrLim) {
        assert (grpLen > 0);
        if (grpLen == 1) {
            return;
        }
        int grpLen1 = grpLen / 2;
        int grpLen2 = grpLen - grpLen1;
        assert (grpLen1 >= 1);
        assert (grpLen2 >= grpLen1);
        int grpStart1 = grpStart;
        int grpStart2 = grpStart + grpLen1;
        DoublesAuxiliary.blockyTandemMergeSortRecursion(keyDst, valDst, keySrc, valSrc, grpStart1, grpLen1, blkSize, arrLim);
        DoublesAuxiliary.blockyTandemMergeSortRecursion(keyDst, valDst, keySrc, valSrc, grpStart2, grpLen2, blkSize, arrLim);
        int arrStart1 = grpStart1 * blkSize;
        int arrStart2 = grpStart2 * blkSize;
        int arrLen1 = grpLen1 * blkSize;
        int arrLen2 = grpLen2 * blkSize;
        if (arrStart2 + arrLen2 > arrLim) {
            arrLen2 = arrLim - arrStart2;
        }
        DoublesAuxiliary.tandemMerge(keySrc, valSrc, arrStart1, arrLen1, arrStart2, arrLen2, keyDst, valDst, arrStart1);
    }

    private static void tandemMerge(double[] keySrc, long[] valSrc, int arrStart1, int arrLen1, int arrStart2, int arrLen2, double[] keyDst, long[] valDst, int arrStart3) {
        int arrStop1 = arrStart1 + arrLen1;
        int arrStop2 = arrStart2 + arrLen2;
        int i1 = arrStart1;
        int i2 = arrStart2;
        int i3 = arrStart3;
        while (i1 < arrStop1 && i2 < arrStop2) {
            if (keySrc[i2] < keySrc[i1]) {
                keyDst[i3] = keySrc[i2];
                valDst[i3] = valSrc[i2];
                ++i3;
                ++i2;
                continue;
            }
            keyDst[i3] = keySrc[i1];
            valDst[i3] = valSrc[i1];
            ++i3;
            ++i1;
        }
        if (i1 < arrStop1) {
            System.arraycopy(keySrc, i1, keyDst, i3, arrStop1 - i1);
            System.arraycopy(valSrc, i1, valDst, i3, arrStop1 - i1);
        } else {
            assert (i2 < arrStop2);
            System.arraycopy(keySrc, i2, keyDst, i3, arrStop2 - i2);
            System.arraycopy(valSrc, i2, valDst, i3, arrStop2 - i2);
        }
    }
}

