/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino.transformers;

import com.linkedin.coral.common.transformers.SqlCallTransformer;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;

public class AsOperatorTransformer
extends SqlCallTransformer {
    @Override
    protected boolean condition(SqlCall sqlCall) {
        return sqlCall.getOperator().getKind() == SqlKind.AS && sqlCall.operandCount() > 2 && sqlCall.operand(0) instanceof SqlBasicCall && ((SqlNode)sqlCall.operand(0)).getKind() == SqlKind.LATERAL;
    }

    @Override
    protected SqlCall transform(SqlCall sqlCall) {
        List<SqlNode> oldAliasOperands = sqlCall.getOperandList();
        ArrayList<SqlNode> newAliasOperands = new ArrayList<SqlNode>();
        SqlCall lateralSqlCall = (SqlCall)sqlCall.operand(0);
        SqlCall newAliasFirstOperand = ((SqlNode)lateralSqlCall.operand(0)).getKind() == SqlKind.UNNEST ? (SqlCall)lateralSqlCall.operand(0) : lateralSqlCall;
        newAliasOperands.add(newAliasFirstOperand);
        newAliasOperands.addAll(oldAliasOperands.subList(1, oldAliasOperands.size()));
        return SqlStdOperatorTable.AS.createCall(SqlParserPos.ZERO, newAliasOperands);
    }
}

