/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino.transformers;

import com.linkedin.coral.common.transformers.SqlCallTransformer;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlWindow;

public class NullOrderingTransformer
extends SqlCallTransformer {
    @Override
    protected boolean condition(SqlCall sqlCall) {
        return sqlCall.getOperator().kind == SqlKind.SELECT && ((SqlSelect)sqlCall).getOrderList() != null || sqlCall.getOperator().kind == SqlKind.WINDOW && ((SqlWindow)sqlCall).getOrderList() != null;
    }

    @Override
    protected SqlCall transform(SqlCall sqlCall) {
        SqlNodeList newOrderList = new SqlNodeList(SqlImplementor.POS);
        for (SqlNode node : this.getOrderList(sqlCall)) {
            SqlNode operand = ((SqlBasicCall)node).getOperandList().get(0);
            if (node instanceof SqlBasicCall && ((SqlBasicCall)node).getOperator().kind == SqlKind.NULLS_LAST && operand instanceof SqlBasicCall && ((SqlBasicCall)operand).getOperator().kind == SqlKind.DESCENDING) {
                newOrderList.add(operand);
                continue;
            }
            newOrderList.add(node);
        }
        this.setOrderList(sqlCall, newOrderList);
        return sqlCall;
    }

    private SqlNodeList getOrderList(SqlCall sqlCall) {
        switch (sqlCall.getOperator().kind) {
            case SELECT: {
                return ((SqlSelect)sqlCall).getOrderList();
            }
            case WINDOW: {
                return ((SqlWindow)sqlCall).getOrderList();
            }
            case DEFAULT: {
                return new SqlNodeList(SqlImplementor.POS);
            }
        }
        return new SqlNodeList(SqlImplementor.POS);
    }

    private void setOrderList(SqlCall sqlCall, SqlNodeList newOrderList) {
        switch (sqlCall.getOperator().kind) {
            case SELECT: {
                ((SqlSelect)sqlCall).setOrderBy(newOrderList);
                break;
            }
            case WINDOW: {
                ((SqlWindow)sqlCall).setOrderList(newOrderList);
            }
        }
    }
}

