/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.preauth.pkinit;

import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbCodec;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.pa.pkinit.AuthPack;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.pa.pkinit.KdcDhKeyInfo;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.pa.pkinit.ReplyKeyPack;
import io.trino.hadoop.$internal.org.apache.kerby.pkix.PkiException;
import io.trino.hadoop.$internal.org.apache.kerby.pkix.PkiUtil;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class PkinitUtil {
    private static final String ID_PKINIT_AUTHDATA = "1.3.6.1.5.2.3.1";

    public static byte[] getSignedAuthPack(PrivateKey privateKey, X509Certificate certificate, AuthPack authPack) throws KrbException {
        byte[] signedData;
        byte[] dataToSign = KrbCodec.encode(authPack);
        try {
            signedData = PkiUtil.getSignedData(privateKey, certificate, dataToSign, ID_PKINIT_AUTHDATA);
        }
        catch (PkiException e) {
            throw new KrbException("Failed to sign data", (Throwable)e);
        }
        return signedData;
    }

    public static byte[] getSignedKdcDhKeyInfo(PrivateKey privateKey, X509Certificate certificate, KdcDhKeyInfo kdcDhKeyInfo) throws KrbException {
        byte[] signedData;
        byte[] dataToSign = KrbCodec.encode(kdcDhKeyInfo);
        try {
            signedData = PkiUtil.getSignedData(privateKey, certificate, dataToSign, ID_PKINIT_AUTHDATA);
        }
        catch (PkiException e) {
            throw new KrbException("Failed to sign data", (Throwable)e);
        }
        return signedData;
    }

    public static byte[] getSignedReplyKeyPack(PrivateKey privateKey, X509Certificate certificate, ReplyKeyPack replyKeyPack) throws KrbException {
        byte[] signedData;
        byte[] dataToSign = KrbCodec.encode(replyKeyPack);
        try {
            signedData = PkiUtil.getSignedData(privateKey, certificate, dataToSign, ID_PKINIT_AUTHDATA);
        }
        catch (PkiException e) {
            throw new KrbException("Failed to sign data", (Throwable)e);
        }
        return signedData;
    }
}

