/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.net;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.SocketTimeoutException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.net.DomainPeer;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.net.PeerServer;
import org.apache.hadoop.net.unix.DomainSocket;

@InterfaceAudience.Private
public class DomainPeerServer
implements PeerServer {
    static final Logger LOG = LoggerFactory.getLogger(DomainPeerServer.class);
    private final DomainSocket sock;

    DomainPeerServer(DomainSocket sock) {
        this.sock = sock;
    }

    public DomainPeerServer(String path, int port) throws IOException {
        this(DomainSocket.bindAndListen(DomainSocket.getEffectivePath(path, port)));
    }

    public String getBindPath() {
        return this.sock.getPath();
    }

    @Override
    public void setReceiveBufferSize(int size) throws IOException {
        this.sock.setAttribute(2, size);
    }

    @Override
    public int getReceiveBufferSize() throws IOException {
        return this.sock.getAttribute(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Peer accept() throws IOException, SocketTimeoutException {
        DomainSocket connSock = this.sock.accept();
        DomainPeer peer = null;
        boolean success = false;
        try {
            peer = new DomainPeer(connSock);
            success = true;
            DomainPeer domainPeer = peer;
            return domainPeer;
        }
        finally {
            if (!success) {
                if (peer != null) {
                    peer.close();
                }
                connSock.close();
            }
        }
    }

    @Override
    public String getListeningString() {
        return "unix:" + this.sock.getPath();
    }

    @Override
    public void close() throws IOException {
        try {
            this.sock.close();
        }
        catch (IOException e) {
            LOG.error("error closing DomainPeerServer: ", e);
        }
    }

    public String toString() {
        return "DomainPeerServer(" + this.getListeningString() + ")";
    }
}

