/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.fs;

import io.trino.filesystem.Location;
import io.trino.filesystem.Locations;
import io.trino.plugin.hive.fs.HiveFileIterator;
import io.trino.plugin.hive.fs.RemoteIterator;
import io.trino.plugin.hive.fs.TrinoFileStatus;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Objects;

public class DirectoryListingFilter
implements RemoteIterator<TrinoFileStatus> {
    private final Location prefix;
    private final RemoteIterator<TrinoFileStatus> delegateIterator;
    private final boolean failOnUnexpectedFiles;
    @Nullable
    private TrinoFileStatus nextElement;

    public DirectoryListingFilter(Location prefix, RemoteIterator<TrinoFileStatus> delegateIterator, boolean failOnUnexpectedFiles) throws IOException {
        this.prefix = Objects.requireNonNull(prefix, "prefix is null");
        this.delegateIterator = Objects.requireNonNull(delegateIterator, "delegateIterator is null");
        this.nextElement = this.findNextElement();
        this.failOnUnexpectedFiles = failOnUnexpectedFiles;
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.nextElement != null;
    }

    @Override
    public TrinoFileStatus next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        TrinoFileStatus thisElement = this.nextElement;
        this.nextElement = this.findNextElement();
        return thisElement;
    }

    private TrinoFileStatus findNextElement() throws IOException {
        while (this.delegateIterator.hasNext()) {
            TrinoFileStatus candidate = this.delegateIterator.next();
            Location parent = Location.of((String)candidate.getPath()).parentDirectory();
            boolean directChild = Locations.areDirectoryLocationsEquivalent((Location)parent, (Location)this.prefix);
            if (!directChild && this.failOnUnexpectedFiles && !DirectoryListingFilter.parentIsHidden(parent, this.prefix)) {
                throw new HiveFileIterator.NestedDirectoryNotAllowedException(candidate.getPath());
            }
            if (!directChild) continue;
            return candidate;
        }
        return null;
    }

    private static boolean parentIsHidden(Location location, Location prefix) {
        if (location.equals((Object)prefix)) {
            return false;
        }
        if (location.fileName().startsWith(".") || location.fileName().startsWith("_")) {
            return true;
        }
        return DirectoryListingFilter.parentIsHidden(location.parentDirectory(), prefix);
    }
}

