/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.recording;

import com.google.common.collect.ImmutableSet;
import io.trino.plugin.hive.HiveColumnStatisticType;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.DatabaseFunctionKey;
import io.trino.plugin.hive.metastore.DatabaseFunctionSignatureKey;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HivePartitionName;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.HiveTableName;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.PartitionFilter;
import io.trino.plugin.hive.metastore.PartitionWithStatistics;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.TablesWithParameterCacheKey;
import io.trino.plugin.hive.metastore.UserTableKey;
import io.trino.plugin.hive.metastore.recording.HiveMetastoreRecording;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.LanguageFunction;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class RecordingHiveMetastore
implements HiveMetastore {
    private final HiveMetastore delegate;
    private final HiveMetastoreRecording recording;

    public RecordingHiveMetastore(HiveMetastore delegate, HiveMetastoreRecording recording) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.recording = Objects.requireNonNull(recording, "recording is null");
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        return this.recording.getDatabase(databaseName, () -> this.delegate.getDatabase(databaseName));
    }

    @Override
    public List<String> getAllDatabases() {
        return this.recording.getAllDatabases(this.delegate::getAllDatabases);
    }

    @Override
    public Optional<Table> getTable(String databaseName, String tableName) {
        return this.recording.getTable(HiveTableName.hiveTableName(databaseName, tableName), () -> this.delegate.getTable(databaseName, tableName));
    }

    @Override
    public Set<HiveColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return this.delegate.getSupportedColumnStatistics(type);
    }

    @Override
    public PartitionStatistics getTableStatistics(Table table) {
        return this.recording.getTableStatistics(HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName()), () -> this.delegate.getTableStatistics(table));
    }

    @Override
    public Map<String, PartitionStatistics> getPartitionStatistics(Table table, List<Partition> partitions) {
        return this.recording.getPartitionStatistics((Set)partitions.stream().map(partition -> HivePartitionName.hivePartitionName(HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName()), MetastoreUtil.makePartitionName(table, partition))).collect(ImmutableSet.toImmutableSet()), () -> this.delegate.getPartitionStatistics(table, partitions));
    }

    @Override
    public void updateTableStatistics(String databaseName, String tableName, AcidTransaction transaction, Function<PartitionStatistics, PartitionStatistics> update) {
        this.verifyRecordingMode();
        this.delegate.updateTableStatistics(databaseName, tableName, transaction, update);
    }

    @Override
    public void updatePartitionStatistics(Table table, String partitionName, Function<PartitionStatistics, PartitionStatistics> update) {
        this.verifyRecordingMode();
        this.delegate.updatePartitionStatistics(table, partitionName, update);
    }

    @Override
    public void updatePartitionStatistics(Table table, Map<String, Function<PartitionStatistics, PartitionStatistics>> updates) {
        this.verifyRecordingMode();
        this.delegate.updatePartitionStatistics(table, updates);
    }

    @Override
    public List<String> getAllTables(String databaseName) {
        return this.recording.getAllTables(databaseName, () -> this.delegate.getAllTables(databaseName));
    }

    @Override
    public List<String> getTablesWithParameter(String databaseName, String parameterKey, String parameterValue) {
        TablesWithParameterCacheKey key = new TablesWithParameterCacheKey(databaseName, parameterKey, parameterValue);
        return this.recording.getTablesWithParameter(key, () -> this.delegate.getTablesWithParameter(databaseName, parameterKey, parameterValue));
    }

    @Override
    public List<String> getAllViews(String databaseName) {
        return this.recording.getAllViews(databaseName, () -> this.delegate.getAllViews(databaseName));
    }

    @Override
    public Optional<List<SchemaTableName>> getAllTables() {
        return this.recording.getAllTables(this.delegate::getAllTables);
    }

    @Override
    public Optional<List<SchemaTableName>> getAllViews() {
        return this.recording.getAllViews(this.delegate::getAllViews);
    }

    @Override
    public void createDatabase(Database database) {
        this.verifyRecordingMode();
        this.delegate.createDatabase(database);
    }

    @Override
    public void dropDatabase(String databaseName, boolean deleteData) {
        this.verifyRecordingMode();
        this.delegate.dropDatabase(databaseName, deleteData);
    }

    @Override
    public void renameDatabase(String databaseName, String newDatabaseName) {
        this.verifyRecordingMode();
        this.delegate.renameDatabase(databaseName, newDatabaseName);
    }

    @Override
    public void setDatabaseOwner(String databaseName, HivePrincipal principal) {
        this.verifyRecordingMode();
        this.delegate.setDatabaseOwner(databaseName, principal);
    }

    @Override
    public void createTable(Table table, PrincipalPrivileges principalPrivileges) {
        this.verifyRecordingMode();
        this.delegate.createTable(table, principalPrivileges);
    }

    @Override
    public void dropTable(String databaseName, String tableName, boolean deleteData) {
        this.verifyRecordingMode();
        this.delegate.dropTable(databaseName, tableName, deleteData);
    }

    @Override
    public void replaceTable(String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        this.verifyRecordingMode();
        this.delegate.replaceTable(databaseName, tableName, newTable, principalPrivileges);
    }

    @Override
    public void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        this.verifyRecordingMode();
        this.delegate.renameTable(databaseName, tableName, newDatabaseName, newTableName);
    }

    @Override
    public void commentTable(String databaseName, String tableName, Optional<String> comment) {
        this.verifyRecordingMode();
        this.delegate.commentTable(databaseName, tableName, comment);
    }

    @Override
    public void setTableOwner(String databaseName, String tableName, HivePrincipal principal) {
        this.verifyRecordingMode();
        this.delegate.setTableOwner(databaseName, tableName, principal);
    }

    @Override
    public void commentColumn(String databaseName, String tableName, String columnName, Optional<String> comment) {
        this.verifyRecordingMode();
        this.delegate.commentColumn(databaseName, tableName, columnName, comment);
    }

    @Override
    public void addColumn(String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        this.verifyRecordingMode();
        this.delegate.addColumn(databaseName, tableName, columnName, columnType, columnComment);
    }

    @Override
    public void renameColumn(String databaseName, String tableName, String oldColumnName, String newColumnName) {
        this.verifyRecordingMode();
        this.delegate.renameColumn(databaseName, tableName, oldColumnName, newColumnName);
    }

    @Override
    public void dropColumn(String databaseName, String tableName, String columnName) {
        this.verifyRecordingMode();
        this.delegate.dropColumn(databaseName, tableName, columnName);
    }

    @Override
    public Optional<Partition> getPartition(Table table, List<String> partitionValues) {
        return this.recording.getPartition(HivePartitionName.hivePartitionName(HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName()), partitionValues), () -> this.delegate.getPartition(table, partitionValues));
    }

    @Override
    public Optional<List<String>> getPartitionNamesByFilter(String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
        return this.recording.getPartitionNamesByFilter(PartitionFilter.partitionFilter(databaseName, tableName, columnNames, partitionKeysFilter), () -> this.delegate.getPartitionNamesByFilter(databaseName, tableName, columnNames, partitionKeysFilter));
    }

    @Override
    public Map<String, Optional<Partition>> getPartitionsByNames(Table table, List<String> partitionNames) {
        return this.recording.getPartitionsByNames((Set)partitionNames.stream().map(partitionName -> HivePartitionName.hivePartitionName(HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName()), partitionName)).collect(ImmutableSet.toImmutableSet()), () -> this.delegate.getPartitionsByNames(table, partitionNames));
    }

    @Override
    public void addPartitions(String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
        this.verifyRecordingMode();
        this.delegate.addPartitions(databaseName, tableName, partitions);
    }

    @Override
    public void dropPartition(String databaseName, String tableName, List<String> parts, boolean deleteData) {
        this.verifyRecordingMode();
        this.delegate.dropPartition(databaseName, tableName, parts, deleteData);
    }

    @Override
    public void alterPartition(String databaseName, String tableName, PartitionWithStatistics partition) {
        this.verifyRecordingMode();
        this.delegate.alterPartition(databaseName, tableName, partition);
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, Optional<String> tableOwner, Optional<HivePrincipal> principal) {
        return this.recording.listTablePrivileges(new UserTableKey(principal, databaseName, tableName, tableOwner), () -> this.delegate.listTablePrivileges(databaseName, tableName, tableOwner, principal));
    }

    @Override
    public boolean functionExists(String databaseName, String functionName, String signatureToken) {
        return this.recording.functionExists(new DatabaseFunctionSignatureKey(databaseName, functionName, signatureToken), () -> this.delegate.functionExists(databaseName, functionName, signatureToken));
    }

    @Override
    public Collection<LanguageFunction> getFunctions(String databaseName) {
        return this.recording.getFunctions(databaseName, () -> this.delegate.getFunctions(databaseName));
    }

    @Override
    public Collection<LanguageFunction> getFunctions(String databaseName, String functionName) {
        return this.recording.getFunctions(new DatabaseFunctionKey(databaseName, functionName), () -> this.delegate.getFunctions(databaseName, functionName));
    }

    @Override
    public void createFunction(String databaseName, String functionName, LanguageFunction function) {
        this.verifyRecordingMode();
        this.delegate.createFunction(databaseName, functionName, function);
    }

    @Override
    public void replaceFunction(String databaseName, String functionName, LanguageFunction function) {
        this.verifyRecordingMode();
        this.delegate.replaceFunction(databaseName, functionName, function);
    }

    @Override
    public void dropFunction(String databaseName, String functionName, String signatureToken) {
        this.verifyRecordingMode();
        this.delegate.dropFunction(databaseName, functionName, signatureToken);
    }

    @Override
    public void grantTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        this.verifyRecordingMode();
        this.delegate.grantTablePrivileges(databaseName, tableName, tableOwner, grantee, grantor, privileges, grantOption);
    }

    @Override
    public void revokeTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        this.verifyRecordingMode();
        this.delegate.revokeTablePrivileges(databaseName, tableName, tableOwner, grantee, grantor, privileges, grantOption);
    }

    @Override
    public void createRole(String role, String grantor) {
        this.verifyRecordingMode();
        this.delegate.createRole(role, grantor);
    }

    @Override
    public void dropRole(String role) {
        this.verifyRecordingMode();
        this.delegate.dropRole(role);
    }

    @Override
    public Set<String> listRoles() {
        return this.recording.listRoles(this.delegate::listRoles);
    }

    @Override
    public void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        this.verifyRecordingMode();
        this.delegate.grantRoles(roles, grantees, adminOption, grantor);
    }

    @Override
    public void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        this.verifyRecordingMode();
        this.delegate.revokeRoles(roles, grantees, adminOption, grantor);
    }

    @Override
    public Set<RoleGrant> listGrantedPrincipals(String role) {
        return this.recording.listGrantedPrincipals(role, () -> this.delegate.listGrantedPrincipals(role));
    }

    @Override
    public Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        return this.recording.listRoleGrants(principal, () -> this.delegate.listRoleGrants(principal));
    }

    private void verifyRecordingMode() {
        if (this.recording.isReplay()) {
            throw new IllegalStateException("Cannot perform Metastore updates in replay mode");
        }
    }
}

