/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.valuewriter;

import io.trino.parquet.writer.valuewriter.PrimitiveValueWriter;
import io.trino.spi.block.Block;
import io.trino.spi.type.DateType;
import java.util.Objects;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.schema.PrimitiveType;

public class DateValueWriter
extends PrimitiveValueWriter {
    private final ValuesWriter valuesWriter;

    public DateValueWriter(ValuesWriter valuesWriter, PrimitiveType parquetType) {
        super(parquetType, valuesWriter);
        this.valuesWriter = Objects.requireNonNull(valuesWriter, "valuesWriter is null");
    }

    @Override
    public void write(Block block) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) continue;
            int value = DateType.DATE.getInt(block, position);
            this.valuesWriter.writeInteger(value);
            this.getStatistics().updateStats(value);
        }
    }
}

