/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.concurrent.MoreFutures;
import io.airlift.units.DataSize;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.util.AsyncQueue;
import io.trino.plugin.hive.util.ThrottledAsyncQueue;
import io.trino.plugin.hudi.HudiSessionProperties;
import io.trino.plugin.hudi.HudiTableHandle;
import io.trino.plugin.hudi.HudiUtil;
import io.trino.plugin.hudi.query.HudiReadOptimizedDirectoryLister;
import io.trino.plugin.hudi.split.HudiBackgroundSplitLoader;
import io.trino.plugin.hudi.split.HudiSplitWeightProvider;
import io.trino.plugin.hudi.split.SizeBasedSplitWeightProvider;
import io.trino.plugin.hudi.table.HudiTableMetaClient;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitSource;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class HudiSplitSource
implements ConnectorSplitSource {
    private final AsyncQueue<ConnectorSplit> queue;
    private final ScheduledFuture splitLoaderFuture;
    private final AtomicReference<TrinoException> trinoException = new AtomicReference();

    public HudiSplitSource(ConnectorSession session, HiveMetastore metastore, Table table, HudiTableHandle tableHandle, TrinoFileSystemFactory fileSystemFactory, Map<String, HiveColumnHandle> partitionColumnHandleMap, ExecutorService executor, ScheduledExecutorService splitLoaderExecutorService, int maxSplitsPerSecond, int maxOutstandingSplits, List<String> partitions) {
        HudiTableMetaClient metaClient = HudiUtil.buildTableMetaClient(fileSystemFactory.create(session), tableHandle.getBasePath());
        List<HiveColumnHandle> partitionColumnHandles = table.getPartitionColumns().stream().map(column -> (HiveColumnHandle)partitionColumnHandleMap.get(column.getName())).collect(Collectors.toList());
        HudiReadOptimizedDirectoryLister hudiDirectoryLister = new HudiReadOptimizedDirectoryLister(tableHandle, metaClient, metastore, table, partitionColumnHandles, partitions);
        this.queue = new ThrottledAsyncQueue(maxSplitsPerSecond, maxOutstandingSplits, (Executor)executor);
        HudiBackgroundSplitLoader splitLoader = new HudiBackgroundSplitLoader(session, tableHandle, hudiDirectoryLister, this.queue, (Executor)new BoundedExecutor((Executor)executor, HudiSessionProperties.getSplitGeneratorParallelism(session)), HudiSplitSource.createSplitWeightProvider(session), partitions);
        this.splitLoaderFuture = splitLoaderExecutorService.schedule(splitLoader, 0L, TimeUnit.MILLISECONDS);
    }

    public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(int maxSize) {
        boolean noMoreSplits = this.isFinished();
        Throwable throwable = (Throwable)this.trinoException.get();
        if (throwable != null) {
            return CompletableFuture.failedFuture(throwable);
        }
        return MoreFutures.toCompletableFuture((ListenableFuture)Futures.transform((ListenableFuture)this.queue.getBatchAsync(maxSize), splits -> new ConnectorSplitSource.ConnectorSplitBatch(splits, noMoreSplits), (Executor)MoreExecutors.directExecutor()));
    }

    public void close() {
        this.queue.finish();
    }

    public boolean isFinished() {
        return this.splitLoaderFuture.isDone() && this.queue.isFinished();
    }

    private static HudiSplitWeightProvider createSplitWeightProvider(ConnectorSession session) {
        if (HudiSessionProperties.isSizeBasedSplitWeightsEnabled(session)) {
            DataSize standardSplitWeightSize = HudiSessionProperties.getStandardSplitWeightSize(session);
            double minimumAssignedSplitWeight = HudiSessionProperties.getMinimumAssignedSplitWeight(session);
            return new SizeBasedSplitWeightProvider(minimumAssignedSplitWeight, standardSplitWeightSize);
        }
        return HudiSplitWeightProvider.uniformStandardWeightProvider();
    }
}

