/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.compaction;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hudi.compaction.HudiCompactionOperation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;

public class HudiCompactionPlan
extends SpecificRecordBase
implements SpecificRecord {
    private static final Schema SCHEMA = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"HoodieCompactionPlan\",\"namespace\":\"org.apache.hudi.avro.model\",\"fields\":[{\"name\":\"operations\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"HoodieCompactionOperation\",\"fields\":[{\"name\":\"baseInstantTime\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}]},{\"name\":\"deltaFilePaths\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}],\"default\":null},{\"name\":\"dataFilePath\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"fileId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}]},{\"name\":\"partitionPath\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"metrics\",\"type\":[\"null\",{\"type\":\"map\",\"values\":\"double\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"bootstrapFilePath\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null}]}}],\"default\":null},{\"name\":\"extraMetadata\",\"type\":[\"null\",{\"type\":\"map\",\"values\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"version\",\"type\":[\"int\",\"null\"],\"default\":1}]}");
    private static final SpecificData MODEL = new SpecificData();
    private List<HudiCompactionOperation> operations;
    private Map<String, String> extraMetadata;
    private Integer version;

    public HudiCompactionPlan() {
    }

    public HudiCompactionPlan(List<HudiCompactionOperation> operations, Map<String, String> extraMetadata, Integer version) {
        this.operations = ImmutableList.copyOf(operations);
        this.extraMetadata = ImmutableMap.copyOf(extraMetadata);
        this.version = version;
    }

    public SpecificData getSpecificData() {
        return MODEL;
    }

    public Schema getSchema() {
        return SCHEMA;
    }

    public List<HudiCompactionOperation> getOperations() {
        return this.operations;
    }

    public Map<String, String> getExtraMetadata() {
        return this.extraMetadata;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Object get(int field) {
        return switch (field) {
            case 0 -> this.operations;
            case 1 -> this.extraMetadata;
            case 2 -> this.version;
            default -> throw new IndexOutOfBoundsException("Invalid index: " + field);
        };
    }

    public void put(int field, Object value) {
        switch (field) {
            case 0: {
                this.operations = ImmutableList.copyOf((Collection)((List)value));
                break;
            }
            case 1: {
                this.extraMetadata = ImmutableMap.copyOf((Map)((Map)value));
                break;
            }
            case 2: {
                this.version = (Integer)value;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field);
            }
        }
    }
}

