/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.files;

import io.trino.filesystem.FileEntry;
import io.trino.filesystem.Location;
import io.trino.plugin.hudi.files.FSUtils;
import java.util.Comparator;
import java.util.Objects;

public class HudiLogFile {
    private static final Comparator<HudiLogFile> LOG_FILE_COMPARATOR_REVERSED = new LogFileComparator().reversed();
    private final String pathStr;
    private final long fileLen;

    public HudiLogFile(FileEntry fileStatus) {
        this.pathStr = fileStatus.location().toString();
        this.fileLen = fileStatus.length();
    }

    public String getFileId() {
        return FSUtils.getFileIdFromLogPath(this.getPath());
    }

    public String getBaseCommitTime() {
        return FSUtils.getBaseCommitTimeFromLogPath(this.getPath());
    }

    public int getLogVersion() {
        return FSUtils.getFileVersionFromLog(this.getPath());
    }

    public String getLogWriteToken() {
        return FSUtils.getWriteTokenFromLogPath(this.getPath());
    }

    public Location getPath() {
        return Location.of((String)this.pathStr);
    }

    public static Comparator<HudiLogFile> getReverseLogFileComparator() {
        return LOG_FILE_COMPARATOR_REVERSED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HudiLogFile that = (HudiLogFile)o;
        return Objects.equals(this.pathStr, that.pathStr);
    }

    public int hashCode() {
        return Objects.hash(this.pathStr);
    }

    public String toString() {
        return "HoodieLogFile{pathStr='" + this.pathStr + "', fileLen=" + this.fileLen + "}";
    }

    public static class LogFileComparator
    implements Comparator<HudiLogFile> {
        private transient Comparator<String> writeTokenComparator;

        private Comparator<String> getWriteTokenComparator() {
            if (null == this.writeTokenComparator) {
                this.writeTokenComparator = Comparator.nullsFirst(Comparator.naturalOrder());
            }
            return this.writeTokenComparator;
        }

        @Override
        public int compare(HudiLogFile o1, HudiLogFile o2) {
            String baseInstantTime2;
            String baseInstantTime1 = o1.getBaseCommitTime();
            if (baseInstantTime1.equals(baseInstantTime2 = o2.getBaseCommitTime())) {
                if (o1.getLogVersion() == o2.getLogVersion()) {
                    return this.getWriteTokenComparator().compare(o1.getLogWriteToken(), o2.getLogWriteToken());
                }
                return Integer.compare(o1.getLogVersion(), o2.getLogVersion());
            }
            return baseInstantTime1.compareTo(baseInstantTime2);
        }
    }
}

