/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.timeline;

import com.google.common.collect.ImmutableSet;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoInputStream;
import io.trino.plugin.hudi.HudiErrorCode;
import io.trino.plugin.hudi.model.HudiInstant;
import io.trino.plugin.hudi.table.HudiTableMetaClient;
import io.trino.plugin.hudi.timeline.HudiDefaultTimeline;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.Set;

public class HudiActiveTimeline
extends HudiDefaultTimeline {
    private static final Set<String> VALID_EXTENSIONS_IN_ACTIVE_TIMELINE = ImmutableSet.of((Object)".commit", (Object)".inflight", (Object)".commit.requested", (Object)".deltacommit", (Object)".deltacommit.inflight", (Object)".deltacommit.requested", (Object[])new String[]{".savepoint", ".savepoint.inflight", ".clean", ".clean.requested", ".clean.inflight", INFLIGHT_COMPACTION_EXTENSION, REQUESTED_COMPACTION_EXTENSION, ".restore.requested", ".restore.inflight", ".restore", ".rollback", ".rollback.requested", ".rollback.inflight", ".replacecommit.requested", ".replacecommit.inflight", ".replacecommit", ".indexing.requested", ".indexing.inflight", ".indexing", ".schemacommit.requested", ".schemacommit.inflight", ".schemacommit"});
    private HudiTableMetaClient metaClient;

    public HudiActiveTimeline(HudiTableMetaClient metaClient) {
        try {
            this.setInstants(metaClient.scanHoodieInstantsFromFileSystem(VALID_EXTENSIONS_IN_ACTIVE_TIMELINE, true));
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HudiErrorCode.HUDI_BAD_DATA, "Failed to scan metadata", (Throwable)e);
        }
        this.metaClient = metaClient;
        this.details = this::getInstantDetails;
    }

    @Deprecated
    public HudiActiveTimeline() {
    }

    @Override
    public Optional<byte[]> getInstantDetails(HudiInstant instant) {
        Location detailLocation = this.getInstantFileNamePath(instant.getFileName());
        return this.readDataFromPath(detailLocation);
    }

    public Optional<byte[]> readCompactionPlanAsBytes(HudiInstant instant) {
        return this.readDataFromPath(Location.of((String)this.metaClient.getMetaAuxiliaryPath()).appendPath(instant.getFileName()));
    }

    private Location getInstantFileNamePath(String fileName) {
        Location metaPath = this.metaClient.getMetaPath();
        if (fileName.contains("schemacommit")) {
            return metaPath.appendPath(".schema").appendPath(fileName);
        }
        return metaPath.appendPath(fileName);
    }

    private Optional<byte[]> readDataFromPath(Location detailPath) {
        Optional<byte[]> optional;
        block8: {
            TrinoInputStream inputStream = this.metaClient.getFileSystem().newInputFile(detailPath).newStream();
            try {
                optional = Optional.of(HudiActiveTimeline.readAsByteArray((InputStream)inputStream));
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new TrinoException((ErrorCodeSupplier)HudiErrorCode.HUDI_BAD_DATA, "Could not read commit details from " + detailPath, (Throwable)e);
                }
            }
            inputStream.close();
        }
        return optional;
    }

    private static byte[] readAsByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(128);
        HudiActiveTimeline.copy(input, bos);
        return bos.toByteArray();
    }

    private static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, len);
        }
    }
}

