/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GrpcRequestTracingInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Stopwatch;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import com.google.cloud.hadoop.repackaged.gcs.com.google.gson.Gson;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Attributes;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.CallOptions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Channel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientCall;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientStreamTracer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Grpc;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Metadata;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.MethodDescriptor;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import java.net.SocketAddress;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class GoogleCloudStorageGrpcTracingInterceptor
implements ClientInterceptor {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final GrpcRequestTracingInfo requestInfo;

    GoogleCloudStorageGrpcTracingInterceptor(GrpcRequestTracingInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
        return channel.newCall(methodDescriptor, callOptions.withStreamTracerFactory(this.getFactory()));
    }

    private ClientStreamTracer.Factory getFactory() {
        return new ClientStreamTracer.Factory(){

            @Override
            public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
                return new GRPCClientStreamTracer(info, headers, GoogleCloudStorageGrpcTracingInterceptor.this.requestInfo);
            }
        };
    }

    private static class GRPCClientStreamTracer
    extends ClientStreamTracer {
        private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").withZone(ZoneOffset.UTC);
        private final ClientStreamTracer.StreamInfo streamInfo;
        private final Gson gson = new Gson();
        private final String initiatingThreadName = Thread.currentThread().getName();
        private final GrpcRequestTracingInfo requestInfo;
        private final Stopwatch stopwatch = Stopwatch.createUnstarted();
        private SocketAddress remoteAddress;

        public GRPCClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers, GrpcRequestTracingInfo requestInfo) {
            this.streamInfo = info;
            this.requestInfo = requestInfo;
        }

        @Override
        public void streamCreated(Attributes transportAttrs, Metadata headers) {
            this.remoteAddress = transportAttrs.get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
            ((GoogleLogger.Api)logger.atInfo()).log(this.toJson(this.getRequestTrackingInfo("streamCreated").put("transportattrs", transportAttrs).put("headers", headers == null ? "null" : headers.toString()).put("streamInfo", this.streamInfo == null ? "null" : this.streamInfo.toString()).build()));
            this.stopwatch.start();
            super.streamCreated(transportAttrs, headers);
        }

        private String toJson(ImmutableMap<String, Object> eventDetails) {
            return this.gson.toJson(eventDetails);
        }

        private ImmutableMap.Builder<String, Object> getRequestTrackingInfo(String message) {
            return new ImmutableMap.Builder<String, String>().put("initiatingthreadname", this.initiatingThreadName).put("remoteaddress", (String)((Object)this.remoteAddress)).put("elapsedmillis", (String)((Object)Long.valueOf(this.stopwatch.elapsed().toMillis()))).put("requestinfo", (String)((Object)this.requestInfo)).put("eventtime", dateTimeFormatter.format(Instant.now())).put("details", message);
        }

        @Override
        public void inboundTrailers(Metadata trailers) {
            ((GoogleLogger.Api)logger.atInfo()).log(this.toJson(this.getRequestTrackingInfo("inboundTrailers()").put("trailers", trailers == null ? "null" : trailers.toString()).build()));
        }

        @Override
        public void streamClosed(Status status) {
            ((GoogleLogger.Api)logger.atInfo()).log(this.toJson(this.getRequestTrackingInfo("streamcloses()").put("status", status).build()));
        }

        @Override
        public void outboundMessage(int seqNo) {
            ((GoogleLogger.Api)logger.atInfo()).log(this.toJson(this.getRequestTrackingInfo("outboundMessage()").put("seqno", seqNo).build()));
        }

        @Override
        public void inboundMessage(int seqNo) {
            ((GoogleLogger.Api)logger.atInfo()).log(this.toJson(this.getRequestTrackingInfo("inboundMessage()").put("seqno", seqNo).build()));
        }

        @Override
        public void outboundMessageSent(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
            ((GoogleLogger.Api)logger.atInfo()).log(this.toJson(this.getRequestTrackingInfo("outboundMessageSent()").put("seqno", seqNo).put("optionalWireSize", optionalWireSize).put("optionalUncompressedSize", optionalUncompressedSize).build()));
        }

        @Override
        public void inboundMessageRead(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
            ((GoogleLogger.Api)logger.atInfo()).log(this.toJson(this.getRequestTrackingInfo("inboundMessageRead()").put("seqno", seqNo).put("optionalWireSize", optionalWireSize).put("optionalUncompressedSize", optionalUncompressedSize).build()));
        }
    }
}

