/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.bookkeeper;

import com.codahale.metrics.MetricRegistry;
import com.qubole.rubix.bookkeeper.BookKeeper;
import com.qubole.rubix.bookkeeper.HeartbeatService;
import com.qubole.rubix.common.metrics.BookKeeperMetrics;
import com.qubole.rubix.spi.BookKeeperFactory;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.thrift.HeartbeatStatus;
import java.io.FileNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class WorkerBookKeeper
extends BookKeeper {
    private static Log log = LogFactory.getLog(WorkerBookKeeper.class);
    private HeartbeatService heartbeatService;

    public WorkerBookKeeper(Configuration conf, BookKeeperMetrics bookKeeperMetrics) throws FileNotFoundException {
        this(conf, bookKeeperMetrics, new BookKeeperFactory());
    }

    public WorkerBookKeeper(Configuration conf, BookKeeperMetrics bookKeeperMetrics, BookKeeperFactory factory) throws FileNotFoundException {
        super(conf, bookKeeperMetrics);
        this.startHeartbeatService(conf, this.metrics, factory);
    }

    @Override
    public void handleHeartbeat(String workerHostname, HeartbeatStatus request) {
        throw new UnsupportedOperationException("Worker node should not handle heartbeat");
    }

    private void startHeartbeatService(Configuration conf, MetricRegistry metrics, BookKeeperFactory factory) {
        if (CacheConfig.isHeartbeatEnabled(conf) || !CacheConfig.isEmbeddedModeEnabled(conf)) {
            this.heartbeatService = new HeartbeatService(conf, metrics, factory, this);
            this.heartbeatService.startAsync();
        }
    }
}

