/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.stream;

import io.trino.orc.OrcCorruptionException;
import io.trino.orc.checkpoint.ByteStreamCheckpoint;
import io.trino.orc.stream.OrcInputStream;
import io.trino.orc.stream.ValueInputStream;
import java.io.IOException;
import java.util.Arrays;

public class ByteInputStream
implements ValueInputStream<ByteStreamCheckpoint> {
    private static final int MIN_REPEAT_SIZE = 3;
    private final OrcInputStream input;
    private final byte[] buffer = new byte[130];
    private int length;
    private int offset;
    private long lastReadInputCheckpoint;

    public ByteInputStream(OrcInputStream input) {
        this.input = input;
        this.lastReadInputCheckpoint = input.getCheckpoint();
    }

    private void readNextBlock() throws IOException {
        this.lastReadInputCheckpoint = this.input.getCheckpoint();
        int control = this.input.read();
        if (control == -1) {
            throw new OrcCorruptionException(this.input.getOrcDataSourceId(), "Read past end of buffer RLE byte");
        }
        this.offset = 0;
        if ((control & 0x80) == 0) {
            this.length = control + 3;
            int value = this.input.read();
            if (value == -1) {
                throw new OrcCorruptionException(this.input.getOrcDataSourceId(), "Reading RLE byte got EOF");
            }
            Arrays.fill(this.buffer, 0, this.length, (byte)value);
        } else {
            this.length = 256 - control;
            this.input.readFully(this.buffer, 0, this.length);
        }
    }

    @Override
    public void seekToCheckpoint(ByteStreamCheckpoint checkpoint) throws IOException {
        if (this.lastReadInputCheckpoint == checkpoint.getInputStreamCheckpoint() && checkpoint.getOffset() <= this.length) {
            this.offset = checkpoint.getOffset();
        } else {
            this.input.seekToCheckpoint(checkpoint.getInputStreamCheckpoint());
            this.length = 0;
            this.offset = 0;
            this.skip(checkpoint.getOffset());
        }
    }

    @Override
    public void skip(long items) throws IOException {
        while (items > 0L) {
            if (this.offset == this.length) {
                this.readNextBlock();
            }
            int consume = Math.toIntExact(Math.min(items, (long)(this.length - this.offset)));
            this.offset += consume;
            items -= (long)consume;
        }
    }

    public byte next() throws IOException {
        if (this.offset == this.length) {
            this.readNextBlock();
        }
        return this.buffer[this.offset++];
    }

    public byte[] next(int items) throws IOException {
        byte[] values = new byte[items];
        this.next(values, items);
        return values;
    }

    public void next(byte[] values, int items) throws IOException {
        int outputOffset = 0;
        while (outputOffset < items) {
            if (this.offset == this.length) {
                this.readNextBlock();
            }
            if (this.length == 0) {
                throw new OrcCorruptionException(this.input.getOrcDataSourceId(), "Unexpected end of stream");
            }
            int chunkSize = Math.min(items - outputOffset, this.length - this.offset);
            System.arraycopy(this.buffer, this.offset, values, outputOffset, chunkSize);
            outputOffset += chunkSize;
            this.offset += chunkSize;
        }
    }
}

