/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.files;

import com.google.common.base.Strings;
import io.trino.filesystem.Location;
import io.trino.plugin.hudi.HudiErrorCode;
import io.trino.plugin.hudi.model.HudiFileFormat;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FSUtils {
    public static final Pattern LOG_FILE_PATTERN = Pattern.compile("\\.(.*)_(.*)\\.(.*)\\.([0-9]*)(_(([0-9]*)-([0-9]*)-([0-9]*)))?");

    private FSUtils() {
    }

    public static String getFileIdFromLogPath(Location location) {
        Matcher matcher = LOG_FILE_PATTERN.matcher(location.fileName());
        if (!matcher.find()) {
            throw new TrinoException((ErrorCodeSupplier)HudiErrorCode.HUDI_BAD_DATA, "Invalid LogFile " + String.valueOf(location));
        }
        return matcher.group(1);
    }

    public static String getBaseCommitTimeFromLogPath(Location location) {
        Matcher matcher = LOG_FILE_PATTERN.matcher(location.fileName());
        if (!matcher.find()) {
            throw new TrinoException((ErrorCodeSupplier)HudiErrorCode.HUDI_BAD_DATA, "Invalid LogFile " + String.valueOf(location));
        }
        return matcher.group(2);
    }

    public static boolean isLogFile(String fileName) {
        Matcher matcher = LOG_FILE_PATTERN.matcher(fileName);
        return matcher.find() && fileName.contains(HudiFileFormat.HOODIE_LOG.getFileExtension());
    }

    public static int getFileVersionFromLog(Location logLocation) {
        Matcher matcher = LOG_FILE_PATTERN.matcher(logLocation.fileName());
        if (!matcher.find()) {
            throw new TrinoException((ErrorCodeSupplier)HudiErrorCode.HUDI_BAD_DATA, "Invalid location " + String.valueOf(logLocation));
        }
        return Integer.parseInt(matcher.group(4));
    }

    public static String getWriteTokenFromLogPath(Location location) {
        Matcher matcher = LOG_FILE_PATTERN.matcher(location.fileName());
        if (!matcher.find()) {
            throw new TrinoException((ErrorCodeSupplier)HudiErrorCode.HUDI_BAD_DATA, "Invalid location " + String.valueOf(location));
        }
        return matcher.group(6);
    }

    public static String getCommitTime(String fullFileName) {
        Matcher matcher = LOG_FILE_PATTERN.matcher(fullFileName);
        if (matcher.find() && fullFileName.contains(HudiFileFormat.HOODIE_LOG.getFileExtension())) {
            return fullFileName.split("_")[1].split("\\.")[0];
        }
        return fullFileName.split("_")[2].split("\\.")[0];
    }

    public static Location getPartitionLocation(Location baseLocation, String partitionPath) {
        return Strings.isNullOrEmpty((String)partitionPath) ? baseLocation : baseLocation.appendPath(partitionPath);
    }
}

