/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.model;

import com.google.common.collect.ImmutableMap;
import io.trino.filesystem.FileEntry;
import io.trino.plugin.hudi.timeline.HudiTimeline;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;

public class HudiInstant
implements Comparable<HudiInstant> {
    private static final Map<String, String> COMPARABLE_ACTIONS = ImmutableMap.of((Object)"compaction", (Object)"commit");
    private static final Comparator<HudiInstant> ACTION_COMPARATOR = Comparator.comparing(instant -> HudiInstant.getComparableAction(instant.getAction()));
    private static final Comparator<HudiInstant> COMPARATOR = Comparator.comparing(HudiInstant::getTimestamp).thenComparing(ACTION_COMPARATOR).thenComparing(HudiInstant::getState);
    private final String timestamp;
    private State state = State.COMPLETED;
    private String action;

    public static String getComparableAction(String action) {
        return COMPARABLE_ACTIONS.getOrDefault(action, action);
    }

    public static String getTimelineFileExtension(String fileName) {
        Objects.requireNonNull(fileName);
        int dotIndex = fileName.indexOf(46);
        return dotIndex == -1 ? "" : fileName.substring(dotIndex);
    }

    public HudiInstant(FileEntry fileEntry) {
        String fileName = fileEntry.location().fileName();
        String fileExtension = HudiInstant.getTimelineFileExtension(fileName);
        this.timestamp = fileName.replace(fileExtension, "");
        this.action = fileExtension.replaceFirst(".", "");
        if (this.action.equals("inflight")) {
            this.action = "commit";
            this.state = State.INFLIGHT;
        } else if (this.action.contains(".inflight")) {
            this.state = State.INFLIGHT;
            this.action = this.action.replace(".inflight", "");
        } else if (this.action.contains(".requested")) {
            this.state = State.REQUESTED;
            this.action = this.action.replace(".requested", "");
        }
    }

    public HudiInstant(State state, String action, String timestamp) {
        this.state = state;
        this.action = action;
        this.timestamp = timestamp;
    }

    public boolean isCompleted() {
        return this.state == State.COMPLETED;
    }

    public boolean isInflight() {
        return this.state == State.INFLIGHT;
    }

    public boolean isRequested() {
        return this.state == State.REQUESTED;
    }

    public String getAction() {
        return this.action;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getFileName() {
        if ("commit".equals(this.action)) {
            return this.isInflight() ? HudiTimeline.makeInflightCommitFileName(this.timestamp) : (this.isRequested() ? HudiTimeline.makeRequestedCommitFileName(this.timestamp) : HudiTimeline.makeCommitFileName(this.timestamp));
        }
        if ("clean".equals(this.action)) {
            return this.isInflight() ? HudiTimeline.makeInflightCleanerFileName(this.timestamp) : (this.isRequested() ? HudiTimeline.makeRequestedCleanerFileName(this.timestamp) : HudiTimeline.makeCleanerFileName(this.timestamp));
        }
        if ("rollback".equals(this.action)) {
            return this.isInflight() ? HudiTimeline.makeInflightRollbackFileName(this.timestamp) : (this.isRequested() ? HudiTimeline.makeRequestedRollbackFileName(this.timestamp) : HudiTimeline.makeRollbackFileName(this.timestamp));
        }
        if ("savepoint".equals(this.action)) {
            return this.isInflight() ? HudiTimeline.makeInflightSavePointFileName(this.timestamp) : HudiTimeline.makeSavePointFileName(this.timestamp);
        }
        if ("deltacommit".equals(this.action)) {
            return this.isInflight() ? HudiTimeline.makeInflightDeltaFileName(this.timestamp) : (this.isRequested() ? HudiTimeline.makeRequestedDeltaFileName(this.timestamp) : HudiTimeline.makeDeltaFileName(this.timestamp));
        }
        if ("compaction".equals(this.action)) {
            if (this.isInflight()) {
                return HudiTimeline.makeInflightCompactionFileName(this.timestamp);
            }
            if (this.isRequested()) {
                return HudiTimeline.makeRequestedCompactionFileName(this.timestamp);
            }
            return HudiTimeline.makeCommitFileName(this.timestamp);
        }
        if ("restore".equals(this.action)) {
            return this.isInflight() ? HudiTimeline.makeInflightRestoreFileName(this.timestamp) : (this.isRequested() ? HudiTimeline.makeRequestedRestoreFileName(this.timestamp) : HudiTimeline.makeRestoreFileName(this.timestamp));
        }
        if ("replacecommit".equals(this.action)) {
            return this.isInflight() ? HudiTimeline.makeInflightReplaceFileName(this.timestamp) : (this.isRequested() ? HudiTimeline.makeRequestedReplaceFileName(this.timestamp) : HudiTimeline.makeReplaceFileName(this.timestamp));
        }
        if ("indexing".equals(this.action)) {
            return this.isInflight() ? HudiTimeline.makeInflightIndexFileName(this.timestamp) : (this.isRequested() ? HudiTimeline.makeRequestedIndexFileName(this.timestamp) : HudiTimeline.makeIndexCommitFileName(this.timestamp));
        }
        if ("schemacommit".equals(this.action)) {
            return this.isInflight() ? HudiTimeline.makeInflightSchemaFileName(this.timestamp) : (this.isRequested() ? HudiTimeline.makeRequestSchemaFileName(this.timestamp) : HudiTimeline.makeSchemaFileName(this.timestamp));
        }
        throw new IllegalArgumentException("Cannot get file name for unknown action " + this.action);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HudiInstant that = (HudiInstant)o;
        return this.state == that.state && Objects.equals(this.action, that.action) && Objects.equals(this.timestamp, that.timestamp);
    }

    public State getState() {
        return this.state;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.action, this.timestamp});
    }

    @Override
    public int compareTo(HudiInstant o) {
        return COMPARATOR.compare(this, o);
    }

    public String toString() {
        return "[" + (this.isInflight() || this.isRequested() ? "==>" : "") + this.timestamp + "__" + this.action + "__" + String.valueOf((Object)this.state) + "]";
    }

    public static enum State {
        REQUESTED,
        INFLIGHT,
        COMPLETED,
        NIL;

    }
}

