/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi.timeline;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.hudi.model.HudiInstant;
import io.trino.plugin.hudi.timeline.HudiTimeline;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HudiDefaultTimeline
implements HudiTimeline {
    private List<HudiInstant> instants;
    protected transient Function<HudiInstant, Optional<byte[]>> details;

    public HudiDefaultTimeline(Stream<HudiInstant> instants, Function<HudiInstant, Optional<byte[]>> details) {
        this.details = details;
        this.setInstants(instants.collect(Collectors.toList()));
    }

    public void setInstants(List<HudiInstant> instants) {
        this.instants = ImmutableList.copyOf(instants);
    }

    public HudiDefaultTimeline() {
    }

    @Override
    public HudiTimeline filterCompletedInstants() {
        return new HudiDefaultTimeline(this.instants.stream().filter(HudiInstant::isCompleted), this.details);
    }

    @Override
    public HudiDefaultTimeline getWriteTimeline() {
        ImmutableSet validActions = ImmutableSet.of((Object)"commit", (Object)"deltacommit", (Object)"compaction", (Object)"replacecommit");
        return new HudiDefaultTimeline(this.instants.stream().filter(arg_0 -> HudiDefaultTimeline.lambda$getWriteTimeline$0((Set)validActions, arg_0)), this.details);
    }

    @Override
    public HudiTimeline getCompletedReplaceTimeline() {
        return new HudiDefaultTimeline(this.instants.stream().filter(s -> s.getAction().equals("replacecommit")).filter(HudiInstant::isCompleted), this.details);
    }

    @Override
    public HudiTimeline filterPendingReplaceTimeline() {
        return new HudiDefaultTimeline(this.instants.stream().filter(s -> s.getAction().equals("replacecommit") && !s.isCompleted()), this.details);
    }

    @Override
    public HudiTimeline filterPendingCompactionTimeline() {
        return new HudiDefaultTimeline(this.instants.stream().filter(s -> s.getAction().equals("compaction") && !s.isCompleted()), this.details);
    }

    public HudiTimeline getCommitsTimeline() {
        return this.getTimelineOfActions((Set<String>)ImmutableSet.of((Object)"commit", (Object)"deltacommit", (Object)"replacecommit"));
    }

    public HudiTimeline getCommitTimeline() {
        return this.getTimelineOfActions((Set<String>)ImmutableSet.of((Object)"commit", (Object)"replacecommit"));
    }

    public HudiTimeline getTimelineOfActions(Set<String> actions) {
        return new HudiDefaultTimeline(this.getInstants().filter(s -> actions.contains(s.getAction())), this::getInstantDetails);
    }

    @Override
    public boolean empty() {
        return this.instants.stream().findFirst().isEmpty();
    }

    @Override
    public int countInstants() {
        return this.instants.size();
    }

    @Override
    public Optional<HudiInstant> firstInstant() {
        return this.instants.stream().findFirst();
    }

    @Override
    public Optional<HudiInstant> nthInstant(int n) {
        if (this.empty() || n >= this.countInstants()) {
            return Optional.empty();
        }
        return Optional.of(this.instants.get(n));
    }

    @Override
    public Optional<HudiInstant> lastInstant() {
        return this.empty() ? Optional.empty() : this.nthInstant(this.countInstants() - 1);
    }

    @Override
    public boolean containsOrBeforeTimelineStarts(String instant) {
        return this.instants.stream().anyMatch(s -> s.getTimestamp().equals(instant)) || this.isBeforeTimelineStarts(instant);
    }

    @Override
    public Stream<HudiInstant> getInstants() {
        return this.instants.stream();
    }

    @Override
    public boolean isBeforeTimelineStarts(String instant) {
        Optional<HudiInstant> firstNonSavepointCommit = this.getFirstNonSavepointCommit();
        return firstNonSavepointCommit.isPresent() && HudiTimeline.compareTimestamps(instant, LESSER_THAN, firstNonSavepointCommit.get().getTimestamp());
    }

    @Override
    public Optional<HudiInstant> getFirstNonSavepointCommit() {
        Optional<HudiInstant> firstCommit = this.firstInstant();
        Set savepointTimestamps = (Set)this.instants.stream().filter(entry -> entry.getAction().equals("savepoint")).map(HudiInstant::getTimestamp).collect(ImmutableSet.toImmutableSet());
        Optional<HudiInstant> firstNonSavepointCommit = firstCommit;
        if (!savepointTimestamps.isEmpty()) {
            firstNonSavepointCommit = this.instants.stream().filter(entry -> !savepointTimestamps.contains(entry.getTimestamp())).findFirst();
        }
        return firstNonSavepointCommit;
    }

    @Override
    public Optional<byte[]> getInstantDetails(HudiInstant instant) {
        return this.details.apply(instant);
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.instants.stream().map(Object::toString).collect(Collectors.joining(","));
    }

    private static /* synthetic */ boolean lambda$getWriteTimeline$0(Set validActions, HudiInstant s) {
        return validActions.contains(s.getAction());
    }
}

