/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.azure;

import com.azure.storage.blob.BlobClient;
import com.google.common.base.Preconditions;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.azure.AzureLocation;
import io.trino.filesystem.azure.AzureOutputStream;
import io.trino.memory.context.AggregatedMemoryContext;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.util.Objects;

class AzureOutputFile
implements TrinoOutputFile {
    private final AzureLocation location;
    private final BlobClient blobClient;
    private final long writeBlockSizeBytes;
    private final int maxWriteConcurrency;
    private final long maxSingleUploadSizeBytes;

    public AzureOutputFile(AzureLocation location, BlobClient blobClient, long writeBlockSizeBytes, int maxWriteConcurrency, long maxSingleUploadSizeBytes) {
        this.location = Objects.requireNonNull(location, "location is null");
        location.location().verifyValidFileLocation();
        this.blobClient = Objects.requireNonNull(blobClient, "blobClient is null");
        Preconditions.checkArgument((writeBlockSizeBytes >= 0L ? 1 : 0) != 0, (Object)"writeBlockSizeBytes is negative");
        this.writeBlockSizeBytes = writeBlockSizeBytes;
        Preconditions.checkArgument((maxWriteConcurrency >= 0 ? 1 : 0) != 0, (Object)"maxWriteConcurrency is negative");
        this.maxWriteConcurrency = maxWriteConcurrency;
        Preconditions.checkArgument((maxSingleUploadSizeBytes >= 0L ? 1 : 0) != 0, (Object)"maxSingleUploadSizeBytes is negative");
        this.maxSingleUploadSizeBytes = maxSingleUploadSizeBytes;
    }

    public boolean exists() {
        return this.blobClient.exists();
    }

    public OutputStream create(AggregatedMemoryContext memoryContext) throws IOException {
        if (this.exists()) {
            throw new FileAlreadyExistsException(this.location.toString());
        }
        return this.createOutputStream(memoryContext, false);
    }

    public OutputStream createOrOverwrite(AggregatedMemoryContext memoryContext) throws IOException {
        return this.createOutputStream(memoryContext, true);
    }

    private AzureOutputStream createOutputStream(AggregatedMemoryContext memoryContext, boolean overwrite) throws IOException {
        return new AzureOutputStream(this.location, this.blobClient, overwrite, memoryContext, this.writeBlockSizeBytes, this.maxWriteConcurrency, this.maxSingleUploadSizeBytes);
    }

    public Location location() {
        return this.location.location();
    }
}

