/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorSplitSource;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveTransactionHandle;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.hudi.ForHudiSplitManager;
import io.trino.plugin.hudi.ForHudiSplitSource;
import io.trino.plugin.hudi.HudiSessionProperties;
import io.trino.plugin.hudi.HudiSplitSource;
import io.trino.plugin.hudi.HudiTableHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.TypeManager;
import jakarta.annotation.PreDestroy;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class HudiSplitManager
implements ConnectorSplitManager {
    private final TypeManager typeManager;
    private final BiFunction<ConnectorIdentity, HiveTransactionHandle, HiveMetastore> metastoreProvider;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final ExecutorService executor;
    private final ScheduledExecutorService splitLoaderExecutorService;

    @Inject
    public HudiSplitManager(TypeManager typeManager, BiFunction<ConnectorIdentity, HiveTransactionHandle, HiveMetastore> metastoreProvider, @ForHudiSplitManager ExecutorService executor, TrinoFileSystemFactory fileSystemFactory, @ForHudiSplitSource ScheduledExecutorService splitLoaderExecutorService) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.metastoreProvider = Objects.requireNonNull(metastoreProvider, "metastoreProvider is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.splitLoaderExecutorService = Objects.requireNonNull(splitLoaderExecutorService, "splitLoaderExecutorService is null");
    }

    @PreDestroy
    public void destroy() {
        this.executor.shutdown();
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle tableHandle, DynamicFilter dynamicFilter, Constraint constraint) {
        HudiTableHandle hudiTableHandle = (HudiTableHandle)tableHandle;
        HiveMetastore metastore = this.metastoreProvider.apply(session.getIdentity(), (HiveTransactionHandle)transaction);
        Table table = (Table)metastore.getTable(hudiTableHandle.getSchemaName(), hudiTableHandle.getTableName()).orElseThrow(() -> new TableNotFoundException(SchemaTableName.schemaTableName((String)hudiTableHandle.getSchemaName(), (String)hudiTableHandle.getTableName())));
        List partitionColumns = HiveUtil.getPartitionKeyColumnHandles((Table)table, (TypeManager)this.typeManager);
        Map partitionColumnHandles = (Map)partitionColumns.stream().collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, Function.identity()));
        List<String> partitions = HudiSplitManager.getPartitions(metastore, hudiTableHandle, partitionColumns);
        HudiSplitSource splitSource = new HudiSplitSource(session, metastore, table, hudiTableHandle, this.fileSystemFactory, partitionColumnHandles, this.executor, this.splitLoaderExecutorService, HudiSessionProperties.getMaxSplitsPerSecond(session), HudiSessionProperties.getMaxOutstandingSplits(session), partitions);
        return new ClassLoaderSafeConnectorSplitSource((ConnectorSplitSource)splitSource, HudiSplitManager.class.getClassLoader());
    }

    private static List<String> getPartitions(HiveMetastore metastore, HudiTableHandle table, List<HiveColumnHandle> partitionColumns) {
        if (partitionColumns.isEmpty()) {
            return ImmutableList.of((Object)"");
        }
        return (List)metastore.getPartitionNamesByFilter(table.getSchemaName(), table.getTableName(), partitionColumns.stream().map(HiveColumnHandle::getName).collect(Collectors.toList()), MetastoreUtil.computePartitionKeyFilter(partitionColumns, table.getPartitionPredicates())).orElseThrow(() -> new TableNotFoundException(table.getSchemaTableName()));
    }
}

