/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.plugin.hudi.HudiTableHandle;
import io.trino.spi.connector.SchemaTableName;
import java.util.Objects;

public class HudiTableInfo {
    private final SchemaTableName table;
    private final String tableType;
    private final String basePath;

    @JsonCreator
    public HudiTableInfo(@JsonProperty(value="table") SchemaTableName table, @JsonProperty(value="tableType") String tableType, @JsonProperty(value="basePath") String basePath) {
        this.table = Objects.requireNonNull(table, "table is null");
        this.tableType = Objects.requireNonNull(tableType, "tableType is null");
        this.basePath = Objects.requireNonNull(basePath, "basePath is null");
    }

    @JsonProperty
    public SchemaTableName getTable() {
        return this.table;
    }

    @JsonProperty
    public String getTableType() {
        return this.tableType;
    }

    @JsonProperty
    public String getBasePath() {
        return this.basePath;
    }

    public static HudiTableInfo from(HudiTableHandle tableHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        return new HudiTableInfo(tableHandle.getSchemaTableName(), tableHandle.getTableType().name(), tableHandle.getBasePath());
    }
}

