/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block;

import alluxio.wire.WorkerIdentity;
import alluxio.wire.WorkerNetAddress;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class BlockWorkerInfo {
    private final WorkerIdentity mIdentity;
    private final WorkerNetAddress mNetAddress;
    private final long mCapacityBytes;
    private final long mUsedBytes;
    private final boolean mActive;

    public BlockWorkerInfo(WorkerIdentity identity, WorkerNetAddress netAddress, long capacityBytes, long usedBytes) {
        this(identity, netAddress, capacityBytes, usedBytes, true);
    }

    public BlockWorkerInfo(WorkerIdentity identity, WorkerNetAddress netAddress, long capacityBytes, long usedBytes, boolean active) {
        this.mIdentity = identity;
        this.mNetAddress = (WorkerNetAddress)Preconditions.checkNotNull((Object)netAddress, (Object)"netAddress");
        this.mCapacityBytes = capacityBytes;
        this.mUsedBytes = usedBytes;
        this.mActive = active;
    }

    public WorkerIdentity getIdentity() {
        return this.mIdentity;
    }

    public WorkerNetAddress getNetAddress() {
        return this.mNetAddress;
    }

    public long getCapacityBytes() {
        return this.mCapacityBytes;
    }

    public long getUsedBytes() {
        return this.mUsedBytes;
    }

    public boolean isActive() {
        return this.mActive;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("identity", (Object)this.mIdentity).add("netAddress", (Object)this.mNetAddress).add("capacityBytes", this.mCapacityBytes).add("usedBytes", this.mUsedBytes).add("active", this.mActive).toString();
    }
}

