/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.stream;

import alluxio.client.block.stream.DataReader;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.CancelledException;
import alluxio.exception.status.DeadlineExceededException;
import alluxio.exception.status.UnavailableException;
import alluxio.network.protocol.RPCProtoMessage;
import alluxio.network.protocol.databuffer.DataBuffer;
import alluxio.network.protocol.databuffer.NettyDataBuffer;
import alluxio.proto.dataserver.Protocol;
import alluxio.proto.status.Status;
import alluxio.util.CommonUtils;
import alluxio.util.network.NettyUtils;
import alluxio.util.proto.ProtoMessage;
import alluxio.wire.WorkerNetAddress;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class NettyDataReader
implements DataReader {
    private static final Logger LOG = LoggerFactory.getLogger(NettyDataReader.class);
    private static final int MAX_PACKETS_IN_FLIGHT = Configuration.getInt((PropertyKey)PropertyKey.USER_NETWORK_NETTY_READER_BUFFER_SIZE_PACKETS);
    private static final long READ_TIMEOUT_MS = Configuration.getMs((PropertyKey)PropertyKey.USER_NETWORK_NETTY_TIMEOUT_MS);
    private static final ByteBuf THROWABLE = Unpooled.buffer((int)0);
    private static final ByteBuf UFS_READ_HEARTBEAT = Unpooled.buffer((int)0);
    private static final ByteBuf EOF_OR_CANCELLED = Unpooled.buffer((int)0);
    private final FileSystemContext mContext;
    private final Channel mChannel;
    private final Protocol.ReadRequest mReadRequest;
    private final WorkerNetAddress mAddress;
    private final BlockingQueue<ByteBuf> mPackets = new LinkedBlockingQueue<ByteBuf>();
    private volatile Throwable mPacketReaderException;
    private long mPosToRead;
    private boolean mDone = false;
    private boolean mClosed = false;

    private NettyDataReader(FileSystemContext context, WorkerNetAddress address, Protocol.ReadRequest readRequest) throws IOException {
        this.mContext = context;
        this.mAddress = address;
        this.mPosToRead = readRequest.getOffset();
        this.mReadRequest = readRequest;
        this.mChannel = this.mContext.acquireNettyChannel(address);
        this.mChannel.pipeline().addLast(new ChannelHandler[]{new PacketReadHandler()});
        this.mChannel.writeAndFlush((Object)new RPCProtoMessage(new ProtoMessage(this.mReadRequest))).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
    }

    @Override
    public long pos() {
        return this.mPosToRead;
    }

    @Override
    public DataBuffer readChunk() throws IOException {
        ByteBuf buf;
        Preconditions.checkState((!this.mClosed ? 1 : 0) != 0, (Object)"PacketReader is closed while reading packets.");
        if (!this.tooManyPacketsPending()) {
            NettyUtils.enableAutoRead((Channel)this.mChannel);
        }
        try {
            while ((buf = this.mPackets.poll(READ_TIMEOUT_MS, TimeUnit.MILLISECONDS)) == UFS_READ_HEARTBEAT) {
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CancelledException((Throwable)e);
        }
        if (buf == null) {
            throw new DeadlineExceededException(String.format("Timeout to read %d from %s.", this.mReadRequest.getBlockId(), this.mChannel.toString()));
        }
        if (buf == THROWABLE) {
            Preconditions.checkNotNull((Object)this.mPacketReaderException, (Object)"mPacketReaderException");
            Throwables.propagateIfPossible((Throwable)this.mPacketReaderException, IOException.class);
            throw AlluxioStatusException.fromCheckedException((Throwable)this.mPacketReaderException);
        }
        if (buf == EOF_OR_CANCELLED) {
            this.mDone = true;
            return null;
        }
        this.mPosToRead += (long)buf.readableBytes();
        Preconditions.checkState((this.mPosToRead - this.mReadRequest.getOffset() <= this.mReadRequest.getLength() ? 1 : 0) != 0);
        return new NettyDataBuffer(buf);
    }

    @Override
    public void close() {
        if (this.mClosed) {
            return;
        }
        try {
            if (this.mDone) {
                return;
            }
            if (!this.mChannel.isOpen()) {
                return;
            }
            if (this.remaining() > 0L) {
                Protocol.ReadRequest cancelRequest = this.mReadRequest.toBuilder().setCancel(true).build();
                this.mChannel.writeAndFlush((Object)new RPCProtoMessage(new ProtoMessage(cancelRequest))).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
            }
            try {
                this.readAndDiscardAll();
            }
            catch (IOException e) {
                LOG.warn("Failed to close the NettyBlockReader (block: {}, address: {}) with exception {}.", new Object[]{this.mReadRequest.getBlockId(), this.mAddress, e.getMessage()});
                CommonUtils.closeChannel((Channel)this.mChannel);
                if (this.mChannel.isOpen()) {
                    this.mChannel.pipeline().removeLast();
                    NettyUtils.enableAutoRead((Channel)this.mChannel);
                }
                this.mContext.releaseNettyChannel(this.mAddress, this.mChannel);
                this.mClosed = true;
                return;
            }
        }
        finally {
            if (this.mChannel.isOpen()) {
                this.mChannel.pipeline().removeLast();
                NettyUtils.enableAutoRead((Channel)this.mChannel);
            }
            this.mContext.releaseNettyChannel(this.mAddress, this.mChannel);
            this.mClosed = true;
        }
    }

    private void readAndDiscardAll() throws IOException {
        DataBuffer buf;
        do {
            if ((buf = this.readChunk()) == null) continue;
            buf.release();
        } while (buf != null);
    }

    private long remaining() {
        return this.mReadRequest.getOffset() + this.mReadRequest.getLength() - this.mPosToRead;
    }

    private boolean tooManyPacketsPending() {
        return this.mPackets.size() >= MAX_PACKETS_IN_FLIGHT;
    }

    public static class Factory
    implements DataReader.Factory {
        private final FileSystemContext mContext;
        private final WorkerNetAddress mAddress;
        private final Protocol.ReadRequest.Builder mReadRequestBuilder;

        public Factory(FileSystemContext context, WorkerNetAddress address, Protocol.ReadRequest.Builder readRequestBuilder) {
            this.mContext = context;
            this.mAddress = address;
            this.mReadRequestBuilder = readRequestBuilder;
        }

        @Override
        public NettyDataReader create(long offset, long len) throws IOException {
            return new NettyDataReader(this.mContext, this.mAddress, this.mReadRequestBuilder.setOffset(offset).setLength(len).build());
        }

        @Override
        public void close() throws IOException {
        }
    }

    private class PacketReadHandler
    extends ChannelInboundHandlerAdapter {
        PacketReadHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws IOException {
            ByteBuf buf;
            if (!(msg instanceof RPCProtoMessage)) {
                throw new IllegalStateException(String.format("Incorrect response type %s, %s.", msg.getClass().getCanonicalName(), msg));
            }
            RPCProtoMessage response = (RPCProtoMessage)msg;
            ProtoMessage message = response.getMessage();
            if (message.isReadResponse()) {
                Preconditions.checkState((message.asReadResponse().getType() == Protocol.ReadResponse.Type.UFS_READ_HEARTBEAT ? 1 : 0) != 0);
                buf = UFS_READ_HEARTBEAT;
            } else if (message.isResponse()) {
                DataBuffer dataBuffer;
                if (message.asResponse().getStatus() != Status.PStatus.CANCELLED) {
                    CommonUtils.unwrapResponseFrom((Protocol.Response)response.getMessage().asResponse(), (Channel)ctx.channel());
                }
                if ((dataBuffer = response.getPayloadDataBuffer()) == null) {
                    buf = EOF_OR_CANCELLED;
                } else {
                    Preconditions.checkState((boolean)(dataBuffer.getNettyOutput() instanceof ByteBuf));
                    buf = (ByteBuf)dataBuffer.getNettyOutput();
                }
            } else {
                throw new IllegalStateException(String.format("Incorrect response type %s.", message.toString()));
            }
            if (NettyDataReader.this.tooManyPacketsPending()) {
                NettyUtils.disableAutoRead((Channel)ctx.channel());
            }
            NettyDataReader.this.mPackets.offer(buf);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            LOG.error("Exception is caught while reading block {} from channel {}:", new Object[]{NettyDataReader.this.mReadRequest.getBlockId(), ctx.channel(), cause});
            if (NettyDataReader.this.mPacketReaderException == null) {
                NettyDataReader.this.mPacketReaderException = cause;
                NettyDataReader.this.mPackets.offer(THROWABLE);
            }
            ctx.close();
        }

        public void channelUnregistered(ChannelHandlerContext ctx) {
            LOG.warn("Channel is closed while reading block {} from channel {}.", (Object)NettyDataReader.this.mReadRequest.getBlockId(), (Object)ctx.channel());
            if (NettyDataReader.this.mPacketReaderException == null) {
                NettyDataReader.this.mPacketReaderException = (Throwable)new UnavailableException(String.format("Channel %s is closed.", NettyDataReader.this.mChannel.toString()));
                NettyDataReader.this.mPackets.offer(THROWABLE);
            }
            ctx.fireChannelUnregistered();
        }
    }
}

