/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.CacheContext;
import alluxio.client.file.cache.CacheManagerOptions;
import alluxio.client.file.cache.CacheManagerWithShadowCache;
import alluxio.client.file.cache.CacheStatus;
import alluxio.client.file.cache.CacheUsage;
import alluxio.client.file.cache.LocalCacheManager;
import alluxio.client.file.cache.NoExceptionCacheManager;
import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.PageInfo;
import alluxio.client.file.cache.PageMetaStore;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.PageNotFoundException;
import alluxio.file.ByteArrayTargetBuffer;
import alluxio.file.ReadTargetBuffer;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.metrics.MultiDimensionalMetricsSystem;
import alluxio.network.protocol.databuffer.DataFileChannel;
import alluxio.resource.LockResource;
import com.codahale.metrics.Counter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.DoubleSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CacheManager
extends AutoCloseable,
CacheStatus {
    public static final Logger LOG = LoggerFactory.getLogger(CacheManager.class);

    default public boolean put(PageId pageId, byte[] page) {
        return this.put(pageId, page, CacheContext.defaults());
    }

    default public boolean put(PageId pageId, ByteBuffer page) {
        return this.put(pageId, page, CacheContext.defaults());
    }

    default public boolean put(PageId pageId, byte[] page, CacheContext cacheContext) {
        return this.put(pageId, ByteBuffer.wrap(page), cacheContext);
    }

    public boolean put(PageId var1, ByteBuffer var2, CacheContext var3);

    default public int get(PageId pageId, int bytesToRead, byte[] buffer, int offsetInBuffer) {
        return this.get(pageId, 0, bytesToRead, buffer, offsetInBuffer);
    }

    default public int get(PageId pageId, int pageOffset, int bytesToRead, byte[] buffer, int offsetInBuffer) {
        return this.get(pageId, pageOffset, bytesToRead, buffer, offsetInBuffer, CacheContext.defaults());
    }

    default public int get(PageId pageId, int pageOffset, ReadTargetBuffer buffer, CacheContext cacheContext) {
        throw new UnsupportedOperationException("This method is unsupported. ");
    }

    default public int get(PageId pageId, int pageOffset, int bytesToRead, byte[] buffer, int offsetInBuffer, CacheContext cacheContext) {
        return this.get(pageId, pageOffset, bytesToRead, (ReadTargetBuffer)new ByteArrayTargetBuffer(buffer, offsetInBuffer), cacheContext);
    }

    public int get(PageId var1, int var2, int var3, ReadTargetBuffer var4, CacheContext var5);

    public int getAndLoad(PageId var1, int var2, int var3, ReadTargetBuffer var4, CacheContext var5, Supplier<byte[]> var6);

    default public List<PageId> getCachedPageIdsByFileId(String fileId, long fileLength) {
        throw new UnsupportedOperationException();
    }

    public void deleteFile(String var1);

    public void deleteTempFile(String var1);

    public boolean delete(PageId var1);

    public State state();

    default public boolean hasPageUnsafe(PageId pageId) {
        throw new UnsupportedOperationException();
    }

    public boolean append(PageId var1, int var2, byte[] var3, CacheContext var4);

    default public void invalidate(Predicate<PageInfo> predicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<CacheUsage> getUsage();

    public void commitFile(String var1);

    public Optional<DataFileChannel> getDataFileChannel(PageId var1, int var2, int var3, CacheContext var4) throws PageNotFoundException;

    public static class Factory {
        private static final Logger LOG = LoggerFactory.getLogger(Factory.class);
        private static final Lock CACHE_INIT_LOCK = new ReentrantLock();
        @GuardedBy(value="CACHE_INIT_LOCK")
        private static final AtomicReference<CacheManager> CACHE_MANAGER = new AtomicReference();

        public static CacheManager get(AlluxioConfiguration conf) throws IOException {
            if (CACHE_MANAGER.get() == null) {
                try (LockResource lockResource = new LockResource(CACHE_INIT_LOCK);){
                    if (CACHE_MANAGER.get() == null) {
                        CACHE_MANAGER.set(Factory.create(conf));
                    }
                }
                catch (IOException e) {
                    Metrics.CREATE_ERRORS.inc();
                    throw new IOException("Failed to create CacheManager", e);
                }
            }
            return CACHE_MANAGER.get();
        }

        public static CacheManager create(AlluxioConfiguration conf) throws IOException {
            CacheManagerOptions options = CacheManagerOptions.create(conf);
            return Factory.create(conf, options, PageMetaStore.create(options));
        }

        public static CacheManager create(AlluxioConfiguration conf, CacheManagerOptions options, PageMetaStore pageMetaStore) throws IOException {
            try {
                boolean isShadowCacheEnabled = conf.getBoolean(PropertyKey.USER_CLIENT_CACHE_SHADOW_ENABLED);
                boolean isNettyDataTransmissionEnable = conf.getBoolean(PropertyKey.USER_NETTY_DATA_TRANSMISSION_ENABLED);
                if (isNettyDataTransmissionEnable) {
                    options.setIsAsyncWriteEnabled(false);
                }
                MultiDimensionalMetricsSystem.setCacheStorageSupplier(pageMetaStore::bytes);
                if (isShadowCacheEnabled) {
                    return new NoExceptionCacheManager(new CacheManagerWithShadowCache(LocalCacheManager.create(options, pageMetaStore), conf));
                }
                return new NoExceptionCacheManager(LocalCacheManager.create(options, pageMetaStore));
            }
            catch (IOException e) {
                Metrics.CREATE_ERRORS.inc();
                LOG.error("Failed to create CacheManager", (Throwable)e);
                throw e;
            }
        }

        static void clear() {
            try (LockResource r = new LockResource(CACHE_INIT_LOCK);){
                CacheManager manager = CACHE_MANAGER.getAndSet(null);
                if (manager != null) {
                    manager.close();
                    MultiDimensionalMetricsSystem.setCacheStorageSupplier((DoubleSupplier)MultiDimensionalMetricsSystem.NULL_SUPPLIER);
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to close CacheManager: {}", (Object)e.toString());
            }
        }

        private Factory() {
        }

        private static final class Metrics {
            private static final Counter CREATE_ERRORS = MetricsSystem.counter((String)MetricKey.CLIENT_CACHE_CREATE_ERRORS.getName());

            private Metrics() {
            }
        }
    }

    public static enum State {
        NOT_IN_USE(0),
        READ_ONLY(1),
        READ_WRITE(2);

        private final int mValue;

        private State(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }
    }
}

