/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.cuckoofilter;

import com.google.common.math.DoubleMath;
import java.math.RoundingMode;

public class CuckooUtils {
    public static int indexHash(int hv, int numBuckets) {
        return hv & numBuckets - 1;
    }

    public static int altIndex(int index, int tag, int numBuckets) {
        return CuckooUtils.indexHash(index ^ tag * 1540483477, numBuckets);
    }

    public static int tagHash(int hv, int bitsPerTag) {
        int tag = hv & (1 << bitsPerTag) - 1;
        return tag == 0 ? 1 : tag;
    }

    public static int optimalBitsPerTag(double fpp, double loadFactor) {
        return DoubleMath.roundToInt((double)(DoubleMath.log2((double)(1.0 / fpp + 3.0)) / loadFactor), (RoundingMode)RoundingMode.UP);
    }

    public static long optimalBuckets(long expectedInsertions, double loadFactor, int tagsPerBucket) {
        long bitPos;
        long bucketsNeeded = DoubleMath.roundToLong((double)(1.0 / loadFactor * (double)expectedInsertions / (double)tagsPerBucket), (RoundingMode)RoundingMode.UP);
        if (bucketsNeeded > (bitPos = Long.highestOneBit(bucketsNeeded))) {
            bitPos <<= 1;
        }
        return bitPos;
    }
}

