/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.evictor;

import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.evictor.CacheEvictorOptions;
import alluxio.client.file.cache.evictor.LRUCacheEvictor;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class NondeterministicLRUCacheEvictor
extends LRUCacheEvictor {
    private int mNumOfCandidate = 16;

    public NondeterministicLRUCacheEvictor(CacheEvictorOptions options) {
        super(options);
    }

    public void setNumOfCandidate(int n) {
        this.mNumOfCandidate = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public PageId evict() {
        Map map = this.mLRUCache;
        synchronized (map) {
            if (this.mLRUCache.isEmpty()) {
                return null;
            }
            Iterator it = this.mLRUCache.keySet().iterator();
            PageId evictionCandidate = (PageId)it.next();
            int numMoveFromTail = ThreadLocalRandom.current().nextInt(this.mNumOfCandidate);
            for (int i = 0; it.hasNext() && i < numMoveFromTail; ++i) {
                evictionCandidate = (PageId)it.next();
            }
            return evictionCandidate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public PageId evictMatching(Predicate<PageId> criterion) {
        Map map = this.mLRUCache;
        synchronized (map) {
            if (this.mLRUCache.isEmpty()) {
                return null;
            }
            int numMoveFromTail = ThreadLocalRandom.current().nextInt(this.mNumOfCandidate);
            PageId evictionCandidate = null;
            for (PageId page : this.mLRUCache.keySet()) {
                if (!criterion.test(page)) continue;
                evictionCandidate = page;
                if (--numMoveFromTail != 0) continue;
                break;
            }
            return evictionCandidate;
        }
    }
}

