/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.dora;

import alluxio.wire.WorkerIdentity;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@VisibleForTesting
@ThreadSafe
public class ConsistentHashProvider {
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_32_fixed();
    private final int mMaxAttempts;
    private final long mWorkerInfoUpdateIntervalNs;
    private final AtomicLong mLastUpdatedTimestamp = new AtomicLong(System.nanoTime());
    private final LongAdder mUpdateCount = new LongAdder();
    private final AtomicReference<Set<WorkerIdentity>> mLastWorkers = new AtomicReference<ImmutableSet>(ImmutableSet.of());
    @Nullable
    private volatile NavigableMap<Integer, WorkerIdentity> mActiveNodesByConsistentHashing;
    private final Object mInitLock = new Object();
    private final int mNumVirtualNodes;

    public ConsistentHashProvider(int maxAttempts, long workerListTtlMs, int numVirtualNodes) {
        this.mMaxAttempts = maxAttempts;
        this.mWorkerInfoUpdateIntervalNs = workerListTtlMs * 1000000L;
        this.mNumVirtualNodes = numVirtualNodes;
    }

    public List<WorkerIdentity> getMultiple(String key, int count) {
        LinkedHashSet<WorkerIdentity> workers = new LinkedHashSet<WorkerIdentity>();
        int attempts = 0;
        while (workers.size() < count && attempts < this.mMaxAttempts) {
            WorkerIdentity selectedWorker = this.get(key, ++attempts);
            workers.add(selectedWorker);
        }
        return ImmutableList.copyOf(workers);
    }

    public void refresh(Set<WorkerIdentity> workers) {
        Set<WorkerIdentity> lastWorkerIds;
        Preconditions.checkArgument((!workers.isEmpty() ? 1 : 0) != 0, (Object)"cannot refresh hash provider with empty worker list");
        this.maybeInitialize(workers);
        if (this.shouldRebuildActiveNodesMapExclusively() && !workers.equals(lastWorkerIds = this.mLastWorkers.get())) {
            ImmutableSet newWorkerIds = ImmutableSet.copyOf(workers);
            NavigableMap<Integer, WorkerIdentity> nodes = ConsistentHashProvider.build((Collection<WorkerIdentity>)newWorkerIds, this.mNumVirtualNodes);
            this.mActiveNodesByConsistentHashing = nodes;
            this.mLastWorkers.set((Set<WorkerIdentity>)newWorkerIds);
            this.mUpdateCount.increment();
        }
    }

    private boolean shouldRebuildActiveNodesMapExclusively() {
        long lastUpdateTs = this.mLastUpdatedTimestamp.get();
        long currentTs = System.nanoTime();
        if (currentTs - lastUpdateTs > this.mWorkerInfoUpdateIntervalNs) {
            return this.mLastUpdatedTimestamp.compareAndSet(lastUpdateTs, currentTs);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeInitialize(Set<WorkerIdentity> workers) {
        if (this.mActiveNodesByConsistentHashing == null) {
            Object object = this.mInitLock;
            synchronized (object) {
                if (this.mActiveNodesByConsistentHashing == null) {
                    ImmutableSet workerIdentities = ImmutableSet.copyOf(workers);
                    this.mActiveNodesByConsistentHashing = ConsistentHashProvider.build((Collection<WorkerIdentity>)workerIdentities, this.mNumVirtualNodes);
                    this.mLastWorkers.set((Set<WorkerIdentity>)workerIdentities);
                    this.mLastUpdatedTimestamp.set(System.nanoTime());
                }
            }
        }
    }

    @VisibleForTesting
    WorkerIdentity get(String key, int index) {
        NavigableMap<Integer, WorkerIdentity> map = this.mActiveNodesByConsistentHashing;
        Preconditions.checkState((map != null ? 1 : 0) != 0, (Object)"Hash provider is not properly initialized");
        return ConsistentHashProvider.get(map, key, index);
    }

    @VisibleForTesting
    static WorkerIdentity get(NavigableMap<Integer, WorkerIdentity> map, String key, int index) {
        HashCode hashCode = HASH_FUNCTION.newHasher().putString((CharSequence)key, StandardCharsets.UTF_8).putInt(index).hash();
        int hashKey = hashCode.asInt();
        Map.Entry<Integer, WorkerIdentity> entry = map.ceilingEntry(hashKey);
        if (entry != null) {
            return entry.getValue();
        }
        Map.Entry<Integer, WorkerIdentity> firstEntry = map.firstEntry();
        if (firstEntry == null) {
            throw new IllegalStateException("Hash provider is empty");
        }
        return firstEntry.getValue();
    }

    @VisibleForTesting
    Set<WorkerIdentity> getLastWorkers() {
        return this.mLastWorkers.get();
    }

    @VisibleForTesting
    NavigableMap<Integer, WorkerIdentity> getActiveNodesMap() {
        return this.mActiveNodesByConsistentHashing;
    }

    @VisibleForTesting
    long getUpdateCount() {
        return this.mUpdateCount.sum();
    }

    @VisibleForTesting
    static NavigableMap<Integer, WorkerIdentity> build(Collection<WorkerIdentity> workers, int numVirtualNodes) {
        Preconditions.checkArgument((!workers.isEmpty() ? 1 : 0) != 0, (Object)"worker list is empty");
        TreeMap<Integer, WorkerIdentity> activeNodesByConsistentHashing = new TreeMap<Integer, WorkerIdentity>();
        for (WorkerIdentity worker : workers) {
            for (int i = 0; i < numVirtualNodes; ++i) {
                HashCode hashCode = HASH_FUNCTION.newHasher().putObject((Object)worker, (Funnel)WorkerIdentity.HashFunnel.INSTANCE).putInt(i).hash();
                activeNodesByConsistentHashing.put(hashCode.asInt(), worker);
            }
        }
        return activeNodesByConsistentHashing;
    }
}

