/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.options;

import alluxio.client.file.FileSystemUtils;
import alluxio.client.file.options.UfsFileSystemOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;

public class FileSystemOptions {
    private final boolean mMetadataCacheEnabled;
    private final boolean mDataCacheEnabled;
    private final boolean mDoraCacheEnabled;
    private final boolean mUfsFallbackEnabled;
    private final Optional<UfsFileSystemOptions> mUfsFileSystemOptions;

    private FileSystemOptions(boolean metadataCacheEnabled, boolean dataCacheEnabled, boolean doraCacheEnabled, boolean ufsFallbackEnabled, Optional<UfsFileSystemOptions> ufsFileSystemOptions) {
        this.mUfsFileSystemOptions = (Optional)Preconditions.checkNotNull(ufsFileSystemOptions);
        this.mMetadataCacheEnabled = metadataCacheEnabled;
        this.mDataCacheEnabled = dataCacheEnabled;
        this.mDoraCacheEnabled = doraCacheEnabled;
        this.mUfsFallbackEnabled = ufsFallbackEnabled;
    }

    public Optional<UfsFileSystemOptions> getUfsFileSystemOptions() {
        return this.mUfsFileSystemOptions;
    }

    public boolean isMetadataCacheEnabled() {
        return this.mMetadataCacheEnabled;
    }

    public boolean isDataCacheEnabled() {
        return this.mDataCacheEnabled;
    }

    public boolean isDoraCacheEnabled() {
        return this.mDoraCacheEnabled;
    }

    public boolean isUfsFallbackEnabled() {
        return this.mUfsFallbackEnabled;
    }

    public static class Builder {
        private boolean mMetadataCacheEnabled;
        private boolean mDataCacheEnabled;
        private boolean mDoraCacheEnabled;
        private boolean mUfsFallbackEnabled;
        private Optional<UfsFileSystemOptions> mUfsFileSystemOptions = Optional.empty();

        public static Builder fromConf(AlluxioConfiguration conf) {
            Builder builder = new Builder();
            builder.setDataCacheEnabled(conf.getBoolean(PropertyKey.USER_CLIENT_CACHE_ENABLED)).setMetadataCacheEnabled(FileSystemUtils.metadataEnabled(conf)).setDoraCacheEnabled(conf.getBoolean(PropertyKey.DORA_ENABLED)).setUfsFallbackEnabled(conf.getBoolean(PropertyKey.DORA_CLIENT_UFS_FALLBACK_ENABLED));
            builder.setUfsFileSystemOptions(new UfsFileSystemOptions(conf.getString(PropertyKey.DORA_CLIENT_UFS_ROOT)));
            return builder;
        }

        public boolean isMetadataCacheEnabled() {
            return this.mMetadataCacheEnabled;
        }

        public Builder setMetadataCacheEnabled(boolean metadataCacheEnabled) {
            this.mMetadataCacheEnabled = metadataCacheEnabled;
            return this;
        }

        public boolean isDataCacheEnabled() {
            return this.mDataCacheEnabled;
        }

        public Builder setDataCacheEnabled(boolean dataCacheEnabled) {
            this.mDataCacheEnabled = dataCacheEnabled;
            return this;
        }

        public boolean isDoraCacheEnabled() {
            return this.mDoraCacheEnabled;
        }

        public Builder setDoraCacheEnabled(boolean doraCacheEnabled) {
            this.mDoraCacheEnabled = doraCacheEnabled;
            return this;
        }

        public boolean isUfsFallbackEnabled() {
            return this.mUfsFallbackEnabled;
        }

        public Builder setUfsFallbackEnabled(boolean ufsFallbackEnabled) {
            this.mUfsFallbackEnabled = ufsFallbackEnabled;
            return this;
        }

        public Optional<UfsFileSystemOptions> getUfsFileSystemOptions() {
            return this.mUfsFileSystemOptions;
        }

        public Builder setUfsFileSystemOptions(UfsFileSystemOptions ufsFileSystemOptions) {
            this.mUfsFileSystemOptions = Optional.of(Objects.requireNonNull(ufsFileSystemOptions));
            return this;
        }

        public FileSystemOptions build() {
            return new FileSystemOptions(this.mMetadataCacheEnabled, this.mDataCacheEnabled, this.mDoraCacheEnabled, this.mUfsFallbackEnabled, this.mUfsFileSystemOptions);
        }
    }
}

