/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.client.file.CacheContext;
import alluxio.grpc.TtlAction;
import alluxio.security.authorization.AccessControlList;
import alluxio.security.authorization.DefaultAccessControlList;
import alluxio.wire.BlockInfo;
import alluxio.wire.FileBlockInfo;
import alluxio.wire.FileInfo;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class URIStatus
implements Serializable {
    private static final long serialVersionUID = -8846678583749711935L;
    private final FileInfo mInfo;
    private final CacheContext mCacheContext;
    private boolean mFromUFSFallBack;

    public URIStatus(FileInfo info) {
        this(info, null);
    }

    public URIStatus(FileInfo info, @Nullable CacheContext context) {
        this.mInfo = (FileInfo)Preconditions.checkNotNull((Object)info, (Object)"info");
        this.mCacheContext = context;
        this.mFromUFSFallBack = false;
    }

    public boolean isFromUFSFallBack() {
        return this.mFromUFSFallBack;
    }

    public URIStatus setFromUFSFallBack() {
        this.mFromUFSFallBack = true;
        return this;
    }

    public AccessControlList getAcl() {
        return this.mInfo.getAcl();
    }

    public DefaultAccessControlList getDefaultAcl() {
        return this.mInfo.getDefaultAcl();
    }

    @Nullable
    public BlockInfo getBlockInfo(long blockId) {
        FileBlockInfo info = this.mInfo.getFileBlockInfo(blockId);
        return info == null ? null : info.getBlockInfo();
    }

    public List<Long> getBlockIds() {
        return this.mInfo.getBlockIds();
    }

    public long getBlockSizeBytes() {
        return this.mInfo.getBlockSizeBytes();
    }

    public long getCreationTimeMs() {
        return this.mInfo.getCreationTimeMs();
    }

    public long getFileId() {
        return this.mInfo.getFileId();
    }

    public String getGroup() {
        return this.mInfo.getGroup();
    }

    public int getInMemoryPercentage() {
        return this.mInfo.getInMemoryPercentage();
    }

    public int getInAlluxioPercentage() {
        return this.mInfo.getInAlluxioPercentage();
    }

    public long getLastModificationTimeMs() {
        return this.mInfo.getLastModificationTimeMs();
    }

    public long getLastAccessTimeMs() {
        return this.mInfo.getLastAccessTimeMs();
    }

    public long getLength() {
        return this.mInfo.getLength();
    }

    public String getName() {
        return this.mInfo.getName();
    }

    public String getPath() {
        return this.mInfo.getPath();
    }

    public int getMode() {
        return this.mInfo.getMode();
    }

    public String getPersistenceState() {
        return this.mInfo.getPersistenceState();
    }

    public long getTtl() {
        return this.mInfo.getTtl();
    }

    public TtlAction getTtlAction() {
        return this.mInfo.getTtlAction();
    }

    public String getUfsPath() {
        return this.mInfo.getUfsPath();
    }

    public String getOwner() {
        return this.mInfo.getOwner();
    }

    public int getReplicationMax() {
        return this.mInfo.getReplicationMax();
    }

    public int getReplicationMin() {
        return this.mInfo.getReplicationMin();
    }

    public boolean isCacheable() {
        return this.mInfo.isCacheable();
    }

    public boolean isCompleted() {
        return this.mInfo.isCompleted();
    }

    public boolean isFolder() {
        return this.mInfo.isFolder();
    }

    public boolean isPersisted() {
        return this.mInfo.isPersisted();
    }

    public boolean isPinned() {
        return this.mInfo.isPinned();
    }

    public Set<String> getPinnedMediumTypes() {
        return this.mInfo.getMediumTypes();
    }

    public boolean isMountPoint() {
        return this.mInfo.isMountPoint();
    }

    public long getMountId() {
        return this.mInfo.getMountId();
    }

    public List<FileBlockInfo> getFileBlockInfos() {
        return this.mInfo.getFileBlockInfos();
    }

    public String getUfsFingerprint() {
        return this.mInfo.getUfsFingerprint();
    }

    public Map<String, byte[]> getXAttr() {
        return this.mInfo.getXAttr();
    }

    @Nullable
    public CacheContext getCacheContext() {
        return this.mCacheContext;
    }

    public FileInfo getFileInfo() {
        return this.mInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        URIStatus uriStatus = (URIStatus)o;
        return Objects.equals(this.mInfo, uriStatus.mInfo) && Objects.equals(this.mCacheContext, uriStatus.mCacheContext);
    }

    public int hashCode() {
        return Objects.hash(this.mInfo, this.mCacheContext);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("info", (Object)this.mInfo).add("cacheContext", (Object)this.mCacheContext).toString();
    }
}

