/*
 * Decompiled with CFR 0.152.
 */
package alluxio.collections;

import alluxio.annotation.SuppressFBWarnings;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class UnmodifiableArrayList<T>
implements List<T> {
    T[] mElements;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
    public UnmodifiableArrayList(T[] elements) {
        Preconditions.checkNotNull(elements);
        this.mElements = elements;
    }

    @Override
    public int size() {
        return this.mElements.length;
    }

    @Override
    public boolean isEmpty() {
        return this.mElements.length == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new Itr();
    }

    @Override
    public Object[] toArray() {
        return this.mElements;
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.mElements;
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException("modification is not supported in UnmodifiableArrayList");
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException("modification is not supported in UnmodifiableArrayList");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("modification is not supported in UnmodifiableArrayList");
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException("modification is not supported in UnmodifiableArrayList");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object element : c) {
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException("modification is not supported in UnmodifiableArrayList");
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException("modification is not supported in UnmodifiableArrayList");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("modification is not supported in UnmodifiableArrayList");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("modification is not supported in UnmodifiableArrayList");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("modification is not supported in UnmodifiableArrayList");
    }

    @Override
    public T get(int index) {
        return this.mElements[index];
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException("modification is not supported in UnmodifiableArrayList");
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.mElements.length; ++i) {
                if (this.mElements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.mElements.length; ++i) {
                if (!o.equals(this.mElements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null) {
            for (int i = this.mElements.length - 1; i >= 0; --i) {
                if (this.mElements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.mElements.length - 1; i >= 0; --i) {
                if (!o.equals(this.mElements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        return new ListItr(0);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        if (index < 0 || index > this.mElements.length) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList is not supported in UnmodifiableArrayList, use the underlying array instead");
    }

    private class ListItr
    extends Itr
    implements ListIterator<T> {
        ListItr(int index) {
            this.mCursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.mCursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.mCursor;
        }

        @Override
        public int previousIndex() {
            return this.mCursor - 1;
        }

        @Override
        public T previous() {
            int i = this.mCursor - 1;
            if (i < 0) {
                throw new NoSuchElementException();
            }
            if (i >= UnmodifiableArrayList.this.mElements.length) {
                throw new ConcurrentModificationException();
            }
            this.mCursor = i;
            this.mLastRet = i;
            return UnmodifiableArrayList.this.mElements[this.mLastRet];
        }

        @Override
        public void set(T e) {
            throw new UnsupportedOperationException("modification is not supported in UnmodifiableArrayList");
        }

        @Override
        public void add(T e) {
            throw new UnsupportedOperationException("modification is not supported in UnmodifiableArrayList");
        }
    }

    private class Itr
    implements Iterator<T> {
        int mCursor;
        int mLastRet = -1;

        Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.mCursor != UnmodifiableArrayList.this.mElements.length;
        }

        @Override
        public T next() {
            int i = this.mCursor;
            if (i >= UnmodifiableArrayList.this.mElements.length) {
                throw new NoSuchElementException();
            }
            this.mCursor = i + 1;
            this.mLastRet = i;
            return UnmodifiableArrayList.this.mElements[this.mLastRet];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("modification is not supported in UnmodifiableArrayList");
        }

        @Override
        public void forEachRemaining(Consumer<? super T> consumer) {
            Objects.requireNonNull(consumer);
            int size = UnmodifiableArrayList.this.mElements.length;
            int i = this.mCursor;
            if (i >= size) {
                return;
            }
            while (i != size) {
                consumer.accept(UnmodifiableArrayList.this.mElements[i++]);
            }
            this.mCursor = i;
            this.mLastRet = i - 1;
        }
    }
}

