/*
 * Decompiled with CFR 0.152.
 */
package alluxio.membership;

import alluxio.annotation.SuppressFBWarnings;
import alluxio.cli.CommandUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.runtime.NotFoundRuntimeException;
import alluxio.membership.MembershipManager;
import alluxio.membership.WorkerClusterView;
import alluxio.util.HashUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.WorkerIdentity;
import alluxio.wire.WorkerInfo;
import alluxio.wire.WorkerNetAddress;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class StaticMembershipManager
implements MembershipManager {
    private final List<WorkerInfo> mMembers;
    private final AlluxioConfiguration mConf;

    public static StaticMembershipManager create(AlluxioConfiguration conf) {
        String workerListFile = conf.getString(PropertyKey.WORKER_STATIC_MEMBERSHIP_MANAGER_CONFIG_FILE);
        List<WorkerInfo> workers = StaticMembershipManager.parseWorkerAddresses(workerListFile, conf);
        return new StaticMembershipManager(conf, workers);
    }

    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    StaticMembershipManager(AlluxioConfiguration conf, List<WorkerInfo> members) {
        this.mConf = conf;
        this.mMembers = members;
    }

    private static List<WorkerInfo> parseWorkerAddresses(String configFile, AlluxioConfiguration conf) {
        ArrayList<WorkerInfo> workerInfos = new ArrayList<WorkerInfo>();
        File file = new File(configFile);
        if (!file.exists()) {
            throw new NotFoundRuntimeException("Not found for static worker config file:" + configFile);
        }
        Set<String> workerHostnames = CommandUtils.readNodeList("", configFile);
        for (String workerHostname : workerHostnames) {
            InetSocketAddress inetAddr;
            WorkerNetAddress workerNetAddress = new WorkerNetAddress().setHost(workerHostname).setContainerHost(Configuration.global().getOrDefault(PropertyKey.WORKER_CONTAINER_HOSTNAME, "")).setRpcPort(conf.getInt(PropertyKey.WORKER_RPC_PORT)).setWebPort(conf.getInt(PropertyKey.WORKER_WEB_PORT)).setHttpServerPort(conf.getInt(PropertyKey.WORKER_HTTP_SERVER_PORT));
            if (Configuration.global().getBoolean(PropertyKey.USER_NETTY_DATA_TRANSMISSION_ENABLED)) {
                inetAddr = NetworkAddressUtils.getBindAddress(NetworkAddressUtils.ServiceType.WORKER_DATA, Configuration.global());
                workerNetAddress.setNettyDataPort(inetAddr.getPort());
            } else {
                inetAddr = NetworkAddressUtils.getConnectAddress(NetworkAddressUtils.ServiceType.WORKER_RPC, Configuration.global());
            }
            workerNetAddress.setDataPort(inetAddr.getPort());
            WorkerIdentity identity = WorkerIdentity.ParserV1.INSTANCE.fromUUID(UUID.nameUUIDFromBytes(workerHostname.getBytes(StandardCharsets.UTF_8)));
            WorkerInfo workerInfo = new WorkerInfo().setIdentity(identity).setAddress(workerNetAddress);
            workerInfos.add(workerInfo);
        }
        return workerInfos;
    }

    @Override
    public void join(WorkerInfo worker) throws IOException {
        WorkerNetAddress addr = worker.getAddress();
        this.mMembers.stream().forEach(m -> m.getAddress().setRpcPort(addr.getRpcPort()).setDataPort(addr.getDataPort()).setDomainSocketPath(addr.getDomainSocketPath()).setNettyDataPort(addr.getNettyDataPort()).setWebPort(addr.getWebPort()).setSecureRpcPort(addr.getSecureRpcPort()).setHttpServerPort(addr.getHttpServerPort()));
    }

    @Override
    public WorkerClusterView getAllMembers() throws IOException {
        return new WorkerClusterView(this.mMembers);
    }

    @Override
    public WorkerClusterView getLiveMembers() throws IOException {
        return new WorkerClusterView(this.mMembers);
    }

    @Override
    public WorkerClusterView getFailedMembers() throws IOException {
        return new WorkerClusterView(Collections.emptyList());
    }

    @Override
    public String showAllMembers() {
        String printFormat = "%s\t%s\t%s%n";
        StringBuilder sb = new StringBuilder(String.format(printFormat, "WorkerId", "Address", "Status"));
        try {
            for (WorkerInfo worker : this.getAllMembers()) {
                String entryLine = String.format(printFormat, HashUtils.hashAsStringMD5(worker.getAddress().dumpMainInfo()), worker.getAddress().getHost() + ":" + worker.getAddress().getRpcPort(), "N/A");
                sb.append(entryLine);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    @Override
    public void stopHeartBeat(WorkerInfo worker) throws IOException {
    }

    @Override
    public void decommission(WorkerInfo worker) throws IOException {
        this.mMembers.remove(worker);
    }

    @Override
    public void close() throws Exception {
    }
}

