/*
 * Decompiled with CFR 0.152.
 */
package alluxio.membership;

import alluxio.wire.WorkerIdentity;
import alluxio.wire.WorkerInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import org.apache.curator.shaded.com.google.common.collect.Streams;

@Immutable
public final class WorkerClusterView
implements Iterable<WorkerInfo> {
    private final Instant mInstantCreated;
    private final Map<WorkerIdentity, WorkerInfo> mWorkers;

    public WorkerClusterView(Iterable<WorkerInfo> workers) {
        this(workers, Instant.now());
    }

    @VisibleForTesting
    WorkerClusterView(Iterable<WorkerInfo> workers, Instant createdTime) {
        this.mWorkers = (Map)Streams.stream(workers).collect(ImmutableMap.toImmutableMap(WorkerInfo::getIdentity, Function.identity(), (first, second) -> {
            throw new IllegalArgumentException(String.format("duplicate workers with the same ID: first: %s, second: %s", first, second));
        }));
        this.mInstantCreated = createdTime;
    }

    public Optional<WorkerInfo> getWorkerById(WorkerIdentity workerIdentity) {
        return Optional.ofNullable(this.mWorkers.get(workerIdentity));
    }

    @Override
    public Iterator<WorkerInfo> iterator() {
        return Iterators.unmodifiableIterator(this.mWorkers.values().iterator());
    }

    public Stream<WorkerInfo> stream() {
        return this.mWorkers.values().stream();
    }

    public Set<WorkerIdentity> workerIds() {
        return this.mWorkers.keySet();
    }

    public int size() {
        return this.mWorkers.size();
    }

    public boolean isEmpty() {
        return this.mWorkers.isEmpty();
    }

    public Instant getSnapshotTime() {
        return this.mInstantCreated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerClusterView that = (WorkerClusterView)o;
        return Objects.equals(this.mInstantCreated, that.mInstantCreated) && Objects.equals(this.mWorkers, that.mWorkers);
    }

    public int hashCode() {
        return Objects.hash(this.mInstantCreated, this.mWorkers);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("InstantCreated", (Object)this.mInstantCreated).add("Workers", this.mWorkers).toString();
    }
}

