/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.netty;

import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.network.ChannelType;
import alluxio.network.netty.IdleWriteHandler;
import alluxio.network.protocol.RPCMessage;
import alluxio.network.protocol.RPCMessageDecoder;
import alluxio.network.protocol.RPCMessageEncoder;
import alluxio.util.network.NettyUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollMode;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class NettyClient {
    private static final RPCMessageEncoder ENCODER = new RPCMessageEncoder();
    private static final RPCMessageDecoder DECODER = new RPCMessageDecoder();
    private static final EventLoopGroup WORKER_GROUP = NettyUtils.createEventLoop(NettyUtils.CHANNEL_TYPE, Configuration.getInt(PropertyKey.USER_NETWORK_NETTY_WORKER_THREADS), "netty-client-worker-%d", true);

    private NettyClient() {
    }

    public static Bootstrap createClientBootstrap(SocketAddress address) {
        Bootstrap boot = new Bootstrap();
        ((Bootstrap)boot.group(WORKER_GROUP)).channel(NettyUtils.getClientChannelClass(!(address instanceof InetSocketAddress)));
        boot.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        boot.option(ChannelOption.TCP_NODELAY, (Object)true);
        boot.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        if (NettyUtils.CHANNEL_TYPE == ChannelType.EPOLL) {
            boot.option(EpollChannelOption.EPOLL_MODE, (Object)EpollMode.LEVEL_TRIGGERED);
        }
        long timeoutMs = Configuration.getMs(PropertyKey.NETWORK_NETTY_HEARTBEAT_TIMEOUT_MS);
        final long heartbeatPeriodMs = Math.max(timeoutMs / 10L, 1L);
        boot.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{RPCMessage.createFrameDecoder()});
                pipeline.addLast(new ChannelHandler[]{ENCODER});
                pipeline.addLast(new ChannelHandler[]{DECODER});
                pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(0L, heartbeatPeriodMs, 0L, TimeUnit.MILLISECONDS)});
                pipeline.addLast(new ChannelHandler[]{new IdleWriteHandler()});
            }
        });
        return boot;
    }
}

