/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.netty;

import alluxio.network.netty.NettyRPCContext;
import alluxio.network.protocol.RPCProtoMessage;
import alluxio.util.CommonUtils;
import alluxio.util.proto.ProtoMessage;
import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public final class NettyRPC {
    private NettyRPC() {
    }

    public static ProtoMessage call(NettyRPCContext context, ProtoMessage request) throws IOException {
        ProtoMessage message;
        Channel channel = (Channel)Preconditions.checkNotNull((Object)context.getChannel());
        Promise promise = channel.eventLoop().newPromise();
        channel.pipeline().addLast(new ChannelHandler[]{new RPCHandler((Promise<ProtoMessage>)promise)});
        channel.writeAndFlush((Object)new RPCProtoMessage(request)).addListener(future -> {
            if (future.cause() != null) {
                future.channel().close();
                promise.tryFailure(future.cause());
            }
        });
        try {
            message = (ProtoMessage)promise.get(context.getTimeoutMs(), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            CommonUtils.closeChannel(channel);
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            CommonUtils.closeChannel(channel);
            throw new RuntimeException(e);
        }
        finally {
            if (channel.isOpen()) {
                channel.pipeline().removeLast();
            }
        }
        if (message.isResponse()) {
            CommonUtils.unwrapResponseFrom(message.asResponse(), context.getChannel());
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireAndForget(NettyRPCContext context, ProtoMessage request) throws IOException {
        Channel channel = (Channel)Preconditions.checkNotNull((Object)context.getChannel());
        AtomicBoolean flushed = new AtomicBoolean(false);
        channel.writeAndFlush((Object)new RPCProtoMessage(request)).addListener(future -> {
            if (future.cause() != null) {
                future.channel().close();
            }
            AtomicBoolean atomicBoolean = flushed;
            synchronized (atomicBoolean) {
                flushed.set(true);
                flushed.notifyAll();
            }
        });
        try {
            AtomicBoolean atomicBoolean = flushed;
            synchronized (atomicBoolean) {
                while (!flushed.get()) {
                    flushed.wait();
                }
            }
        }
        catch (InterruptedException e) {
            CommonUtils.closeChannel(channel);
            throw new RuntimeException(e);
        }
    }

    public static class RPCHandler
    extends ChannelInboundHandlerAdapter {
        private final Promise<ProtoMessage> mPromise;

        public RPCHandler(Promise<ProtoMessage> promise) {
            this.mPromise = promise;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (!this.acceptMessage(msg)) {
                ctx.fireChannelRead(msg);
                return;
            }
            ProtoMessage message = ((RPCProtoMessage)msg).getMessage();
            this.mPromise.trySuccess((Object)message);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            this.mPromise.tryFailure(cause);
            ctx.close();
        }

        public void channelUnregistered(ChannelHandlerContext ctx) {
            this.mPromise.tryFailure((Throwable)new IOException("ChannelClosed"));
            ctx.fireChannelUnregistered();
        }

        protected boolean acceptMessage(Object msg) {
            return msg instanceof RPCProtoMessage;
        }
    }
}

