/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.protocol;

import alluxio.network.protocol.RPCMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
@ThreadSafe
public final class RPCMessageDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private static final Logger LOG = LoggerFactory.getLogger(RPCMessageDecoder.class);

    public void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        RPCMessage.Type type = RPCMessage.Type.decode(in);
        RPCMessage message = RPCMessage.decodeMessage(type, in);
        out.add(message);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.error("Error in decoding message.", cause);
        ctx.close();
    }
}

