/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.protocol;

import alluxio.network.protocol.RPCMessage;
import alluxio.network.protocol.databuffer.CompositeDataBuffer;
import alluxio.network.protocol.databuffer.DataBuffer;
import alluxio.network.protocol.databuffer.DataFileChannel;
import alluxio.network.protocol.databuffer.NettyDataBuffer;
import alluxio.network.protocol.databuffer.NioDataBuffer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ChannelHandler.Sharable
@ThreadSafe
public final class RPCMessageEncoder
extends MessageToMessageEncoder<RPCMessage> {
    protected void encode(ChannelHandlerContext ctx, RPCMessage in, List<Object> out) throws Exception {
        RPCMessage.Type type = in.getType();
        long bodyBytes = 0L;
        DataBuffer payload = null;
        if (in.hasPayload()) {
            payload = in.getPayloadDataBuffer();
            bodyBytes = payload.getLength();
        }
        int lengthBytes = 8;
        int typeBytes = type.getEncodedLength();
        int messageBytes = in.getEncodedLength();
        int headerBytes = lengthBytes + typeBytes + messageBytes;
        long frameBytes = (long)headerBytes + bodyBytes;
        ByteBuf buffer = ctx.alloc().buffer();
        buffer.writeLong(frameBytes);
        type.encode(buffer);
        in.encode(buffer);
        out.add(buffer);
        if (payload != null && bodyBytes > 0L) {
            if (payload instanceof NettyDataBuffer || payload instanceof NioDataBuffer) {
                ByteBuf buf = (ByteBuf)payload.getNettyOutput();
                out.add(buf);
            } else if (payload instanceof DataFileChannel) {
                FileRegion fileRegion = (FileRegion)payload.getNettyOutput();
                out.add(fileRegion);
            } else if (payload instanceof CompositeDataBuffer) {
                List dataFileChannels = (List)payload.getNettyOutput();
                for (DataBuffer dataFileChannel : dataFileChannels) {
                    out.add(dataFileChannel.getNettyOutput());
                }
            } else {
                throw new IllegalArgumentException("Unexpected payload type");
            }
        }
    }
}

