/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.exception.ExceptionMessage;
import alluxio.underfs.AtomicFileOutputStreamCallback;
import alluxio.underfs.ContentHashable;
import alluxio.underfs.options.CreateOptions;
import alluxio.util.IdUtils;
import alluxio.util.io.PathUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class AtomicFileOutputStream
extends OutputStream
implements ContentHashable {
    private static final Logger LOG = LoggerFactory.getLogger(AtomicFileOutputStream.class);
    private AtomicFileOutputStreamCallback mUfs;
    private CreateOptions mOptions;
    private String mPermanentPath;
    private String mTemporaryPath;
    private OutputStream mTemporaryOutputStream;
    private boolean mClosed = false;

    public AtomicFileOutputStream(String path, AtomicFileOutputStreamCallback ufs, CreateOptions options) throws IOException {
        this.mOptions = options;
        this.mPermanentPath = path;
        this.mTemporaryPath = PathUtils.temporaryFileName(IdUtils.getRandomNonNegativeLong(), path);
        this.mTemporaryOutputStream = ufs.createDirect(this.mTemporaryPath, options);
        this.mUfs = ufs;
    }

    @Override
    public void write(int b) throws IOException {
        this.mTemporaryOutputStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.mTemporaryOutputStream.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.mTemporaryOutputStream.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mTemporaryOutputStream.close();
        try {
            if (!this.mUfs.renameFile(this.mTemporaryPath, this.mPermanentPath)) {
                throw new IOException(ExceptionMessage.FAILED_UFS_RENAME.getMessage(this.mTemporaryPath, this.mPermanentPath));
            }
        }
        catch (IOException e) {
            try {
                if (!this.mUfs.deleteFile(this.mTemporaryPath)) {
                    LOG.warn("Failed to delete temporary file {} after failing to rename it to {}", (Object)this.mTemporaryPath, (Object)this.mPermanentPath);
                }
            }
            catch (IOException e2) {
                LOG.warn("Exception when deleting temporary file {} after failing to rename it to {}", new Object[]{this.mTemporaryPath, this.mPermanentPath, e2});
            }
            throw e;
        }
        if (this.mOptions.getOwner() != null || this.mOptions.getGroup() != null) {
            try {
                this.mUfs.setOwner(this.mPermanentPath, this.mOptions.getOwner(), this.mOptions.getGroup());
            }
            catch (Exception e) {
                LOG.warn("Failed to update the ufs ownership, default values will be used. " + e);
            }
        }
        this.mClosed = true;
    }

    @Override
    public Optional<String> getContentHash() throws IOException {
        return Optional.of(this.mUfs.getFileStatus(this.mPermanentPath).getContentHash());
    }
}

