/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.AlluxioURI;
import alluxio.collections.Pair;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.runtime.AlluxioRuntimeException;
import alluxio.retry.CountingRetry;
import alluxio.retry.ExponentialBackoffRetry;
import alluxio.retry.RetryPolicy;
import alluxio.underfs.BaseUnderFileSystem;
import alluxio.underfs.UfsDirectoryStatus;
import alluxio.underfs.UfsFileStatus;
import alluxio.underfs.UfsStatus;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.options.CreateOptions;
import alluxio.underfs.options.DeleteOptions;
import alluxio.underfs.options.FileLocationOptions;
import alluxio.underfs.options.GetStatusOptions;
import alluxio.underfs.options.ListOptions;
import alluxio.underfs.options.MkdirsOptions;
import alluxio.underfs.options.OpenOptions;
import alluxio.util.CommonUtils;
import alluxio.util.executor.ExecutorServiceFactories;
import alluxio.util.io.PathUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import io.grpc.Status;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.http.conn.ConnectTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class ObjectUnderFileSystem
extends BaseUnderFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectUnderFileSystem.class);
    private static final int DEFAULT_MAX_LISTING_CHUNK_LENGTH = 1000;
    protected static final char PATH_SEPARATOR_CHAR = '/';
    protected static final String PATH_SEPARATOR = String.valueOf('/');
    protected ExecutorService mExecutorService;
    protected final Supplier<String> mRootKeySupplier = CommonUtils.memoize(this::getRootKey);
    private final boolean mBreadcrumbsEnabled;

    protected ObjectUnderFileSystem(AlluxioURI uri, UnderFileSystemConfiguration ufsConf) {
        super(uri, ufsConf);
        int numThreads = this.mUfsConf.getInt(PropertyKey.UNDERFS_OBJECT_STORE_SERVICE_THREADS);
        this.mExecutorService = ExecutorServiceFactories.fixedThreadPool("alluxio-underfs-object-service-worker", numThreads).create();
        this.mBreadcrumbsEnabled = this.mUfsConf.getBoolean(PropertyKey.UNDERFS_OBJECT_STORE_BREADCRUMBS_ENABLED);
    }

    @Override
    public void cleanup() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void connectFromMaster(String hostname) {
    }

    @Override
    public void connectFromWorker(String hostname) {
    }

    @Override
    public OutputStream create(String path, CreateOptions options) throws IOException {
        if (options.getCreateParent() && !this.mUfsConf.getBoolean(PropertyKey.UNDERFS_OBJECT_STORE_SKIP_PARENT_DIRECTORY_CREATION) && !this.mkdirs(this.getParentPath(path))) {
            throw new IOException(ExceptionMessage.PARENT_CREATION_FAILED.getMessage(path));
        }
        return this.createObject(this.stripPrefixIfPresent(path));
    }

    @Override
    public OutputStream createNonexistingFile(String path) throws IOException {
        return this.retryOnException(() -> this.create(path), () -> "create file " + path);
    }

    @Override
    public OutputStream createNonexistingFile(String path, CreateOptions options) throws IOException {
        return this.retryOnException(() -> this.create(path, options), () -> "create file " + path + " with options " + options);
    }

    @Override
    public boolean deleteFile(String path) throws IOException {
        return this.deleteObject(this.stripPrefixIfPresent(path));
    }

    @Override
    public boolean deleteExistingFile(String path) throws IOException {
        return this.retryOnFalse(() -> this.deleteFile(path), () -> "delete existing file " + path);
    }

    @Override
    public boolean deleteDirectory(String path, DeleteOptions options) throws IOException {
        if (!options.isRecursive()) {
            UfsStatus[] children = this.listInternal(path, ListOptions.defaults());
            if (children == null) {
                LOG.error("Unable to delete path because {} is not a directory ", (Object)path);
                return false;
            }
            if (children.length != 0) {
                LOG.error("Unable to delete {} because it is a non empty directory. Specify recursive as true in order to delete non empty directories.", (Object)path);
                return false;
            }
            return this.deleteObject(this.stripPrefixIfPresent(this.convertToFolderName(path)));
        }
        DeleteBuffer deleteBuffer = new DeleteBuffer();
        UfsStatus[] pathsToDelete = this.listInternal(path, ListOptions.defaults().setRecursive(true));
        if (pathsToDelete == null) {
            LOG.warn("Unable to delete {} because listInternal returns null", (Object)path);
            return false;
        }
        Arrays.sort(pathsToDelete, Comparator.comparing(UfsStatus::getName).reversed());
        for (UfsStatus pathToDelete : pathsToDelete) {
            String pathKey = this.stripPrefixIfPresent(PathUtils.concatPath((Object)path, (Object)pathToDelete.getName()));
            if (pathToDelete.isDirectory()) {
                deleteBuffer.add(this.convertToFolderName(pathKey));
                continue;
            }
            deleteBuffer.add(pathKey);
        }
        deleteBuffer.add(this.stripPrefixIfPresent(this.convertToFolderName(path)));
        int filesDeleted = deleteBuffer.getResult().size();
        if (filesDeleted != deleteBuffer.mEntriesAdded) {
            LOG.warn("Failed to delete directory, successfully deleted {} files out of {}.", (Object)filesDeleted, (Object)deleteBuffer.mEntriesAdded);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteExistingDirectory(String path) throws IOException {
        return this.retryOnFalse(() -> this.deleteDirectory(path), () -> "delete directory " + path);
    }

    @Override
    public boolean deleteExistingDirectory(String path, DeleteOptions options) throws IOException {
        return this.retryOnFalse(() -> this.deleteDirectory(path, options), () -> "delete directory " + path + " with options " + options);
    }

    @Override
    public long getBlockSizeByte(String path) throws IOException {
        return this.mUfsConf.getBytes(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT);
    }

    @Override
    public UfsDirectoryStatus getDirectoryStatus(String path) throws IOException {
        if (this.isDirectory(path)) {
            ObjectPermissions permissions = this.getPermissions();
            return new UfsDirectoryStatus(path, permissions.getOwner(), permissions.getGroup(), permissions.getMode());
        }
        LOG.debug("Error fetching directory status, assuming directory {} does not exist", (Object)path);
        throw new FileNotFoundException("Failed to fetch directory status " + path);
    }

    @Override
    public UfsDirectoryStatus getExistingDirectoryStatus(String path) throws IOException {
        return this.retryOnException(() -> this.getDirectoryStatus(path), () -> "get status of directory " + path);
    }

    @Override
    @Nullable
    public List<String> getFileLocations(String path) throws IOException {
        LOG.debug("getFileLocations is not supported when using default ObjectUnderFileSystem.");
        return null;
    }

    @Override
    @Nullable
    public List<String> getFileLocations(String path, FileLocationOptions options) throws IOException {
        LOG.debug("getFileLocations is not supported when using default ObjectUnderFileSystem.");
        return null;
    }

    @Override
    public long getSpace(String path, UnderFileSystem.SpaceType type) throws IOException {
        return -1L;
    }

    @Override
    public UfsFileStatus getFileStatus(String path, GetStatusOptions options) throws IOException {
        ObjectStatus details = this.getObjectStatus(this.stripPrefixIfPresent(path));
        if (details != null) {
            ObjectPermissions permissions = this.getPermissions();
            return new UfsFileStatus(path, details.getContentHash(), details.getContentLength(), details.getLastModifiedTimeMs(), permissions.getOwner(), permissions.getGroup(), permissions.getMode(), this.mUfsConf.getBytes(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT));
        }
        LOG.debug("Error fetching file status, assuming file {} does not exist", (Object)path);
        throw new FileNotFoundException("Failed to fetch file status " + path);
    }

    @Override
    public UfsFileStatus getExistingFileStatus(String path) throws IOException {
        return this.retryOnException(() -> this.getFileStatus(path), () -> "get status of file " + path);
    }

    @Override
    public UfsStatus getStatus(String path, GetStatusOptions options) throws IOException {
        if (this.isRoot(path)) {
            return this.getDirectoryStatus(path);
        }
        ObjectStatus details = this.getObjectStatus(this.stripPrefixIfPresent(path));
        if (details != null) {
            ObjectPermissions permissions = this.getPermissions();
            return new UfsFileStatus(path, details.getContentHash(), details.getContentLength(), details.getLastModifiedTimeMs(), permissions.getOwner(), permissions.getGroup(), permissions.getMode(), this.mUfsConf.getBytes(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT));
        }
        return this.getDirectoryStatus(path);
    }

    @Override
    public UfsStatus getExistingStatus(String path) throws IOException {
        return this.retryOnException(() -> this.getStatus(path), () -> "get status of " + path);
    }

    @Override
    public boolean isDirectory(String path) throws IOException {
        if (this.isRoot(path)) {
            return true;
        }
        String keyAsFolder = this.convertToFolderName(this.stripPrefixIfPresent(path));
        if (this.getObjectStatus(keyAsFolder) != null) {
            return true;
        }
        return this.getObjectListingChunkForPath(path, true) != null;
    }

    @Override
    public boolean isExistingDirectory(String path) throws IOException {
        return this.retryOnException(() -> this.isDirectory(path), () -> "check if " + path + " is a directory");
    }

    @Override
    public void setAttribute(String path, String name, byte[] value) throws IOException {
        if (this.isDirectory(path = this.stripPrefixIfPresent(path))) {
            this.setObjectTagging(this.convertToFolderName(path), name, new String(value));
        } else {
            this.setObjectTagging(path, name, new String(value));
        }
    }

    @Override
    public Map<String, String> getAttributes(String path) throws IOException {
        path = this.stripPrefixIfPresent(path);
        try {
            if (this.isDirectory(path)) {
                return this.getObjectTags(this.convertToFolderName(path));
            }
            return this.getObjectTags(path);
        }
        catch (AlluxioRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.NOT_FOUND) {
                return null;
            }
            throw e;
        }
    }

    protected abstract void setObjectTagging(String var1, String var2, String var3) throws IOException;

    protected abstract Map<String, String> getObjectTags(String var1) throws IOException;

    @Override
    public boolean isFile(String path) throws IOException {
        return !this.isRoot(path) && this.getObjectStatus(this.stripPrefixIfPresent(path)) != null;
    }

    @Override
    public boolean isObjectStorage() {
        return true;
    }

    @Override
    public UfsStatus[] listStatus(String path) throws IOException {
        return this.listInternal(path, ListOptions.defaults());
    }

    @Override
    public UfsStatus[] listStatus(String path, ListOptions options) throws IOException {
        return this.listInternal(path, options);
    }

    @Override
    @Nullable
    public Iterator<UfsStatus> listStatusIterable(String path, ListOptions options, String startAfter, int batchSize) throws IOException {
        ObjectListingChunk chunk = this.getObjectListingChunkForPath(path, options.isRecursive(), startAfter, batchSize);
        if (chunk == null) {
            String keyAsFolder = this.convertToFolderName(this.stripPrefixIfPresent(path));
            if (this.getObjectStatus(keyAsFolder) != null) {
                return Collections.emptyIterator();
            }
            return null;
        }
        return new UfsStatusIterator(path, options.isRecursive(), chunk);
    }

    @Override
    public boolean mkdirs(String path, MkdirsOptions options) throws IOException {
        if (path == null) {
            return false;
        }
        if (this.isDirectory(path)) {
            return true;
        }
        if (this.isFile(path)) {
            LOG.error("Cannot create directory {} because it is already a file.", (Object)path);
            return false;
        }
        if (!options.getCreateParent()) {
            if (this.parentExists(path)) {
                return this.mkdirsInternal(path);
            }
            LOG.error("Cannot create directory {} because parent does not exist", (Object)path);
            return false;
        }
        if (this.parentExists(path)) {
            return this.mkdirsInternal(path);
        }
        String parentKey = this.getParentPath(path);
        return this.mkdirs(parentKey) && this.mkdirsInternal(path);
    }

    @Override
    public InputStream open(String path, OpenOptions options) throws IOException {
        return this.openObject(this.stripPrefixIfPresent(path), options, this.getRetryOncePolicy());
    }

    @Override
    public InputStream openExistingFile(String path) throws IOException {
        return this.openExistingFile(path, OpenOptions.defaults());
    }

    @Override
    public InputStream openExistingFile(String path, OpenOptions options) throws IOException {
        return this.openObject(this.stripPrefixIfPresent(path), options, this.getRetryPolicy());
    }

    @Override
    public boolean renameDirectory(String src, String dst) throws IOException {
        if (this.exists(dst)) {
            LOG.error("Unable to rename {} to {} because destination already exists.", (Object)src, (Object)dst);
            return false;
        }
        DeleteBuffer deleteBuffer = new DeleteBuffer();
        boolean result = this.renameDirectoryInternal(src, dst, deleteBuffer);
        int fileDeleted = deleteBuffer.getResult().size();
        if (fileDeleted != deleteBuffer.mEntriesAdded) {
            LOG.warn("Failed to rename directory, successfully deleted {} files out of {}.", (Object)fileDeleted, (Object)deleteBuffer.mEntriesAdded);
            return false;
        }
        return result;
    }

    private boolean renameDirectoryInternal(String src, String dst, DeleteBuffer deleteBuffer) throws IOException {
        UfsStatus[] children = this.listInternal(src, ListOptions.defaults());
        if (children == null) {
            LOG.error("Failed to list directory {}, aborting rename.", (Object)src);
            return false;
        }
        String srcKey = this.stripPrefixIfPresent(this.convertToFolderName(src));
        if (!this.copyObject(srcKey, this.stripPrefixIfPresent(this.convertToFolderName(dst)))) {
            return false;
        }
        deleteBuffer.add(srcKey);
        RenameBuffer buffer = new RenameBuffer(deleteBuffer);
        for (UfsStatus child : children) {
            String childSrcPath = PathUtils.concatPath((Object)src, (Object)child.getName());
            String childDstPath = PathUtils.concatPath((Object)dst, (Object)child.getName());
            if (child.isDirectory()) {
                if (this.renameDirectoryInternal(childSrcPath, childDstPath, deleteBuffer)) continue;
                LOG.error("Failed to rename path {} to {}, aborting rename.", (Object)childSrcPath, (Object)childDstPath);
                return false;
            }
            buffer.add(new Pair<String, String>(childSrcPath, childDstPath));
        }
        int filesRenamed = buffer.getResult().size();
        if (filesRenamed != buffer.mEntriesAdded) {
            LOG.warn("Failed to rename directory, successfully renamed {} files out of {}.", (Object)filesRenamed, (Object)buffer.mEntriesAdded);
            return false;
        }
        return true;
    }

    @Override
    public boolean renameRenamableDirectory(String src, String dst) throws IOException {
        return this.retryOnFalse(() -> this.renameDirectory(src, dst), () -> "rename directory from " + src + " to " + dst);
    }

    @Override
    public boolean renameFile(String src, String dst) throws IOException {
        if (!this.isFile(src)) {
            LOG.error("Unable to rename {} to {} because source does not exist or is a directory.", (Object)src, (Object)dst);
            return false;
        }
        if (this.exists(dst)) {
            LOG.error("Unable to rename {} to {} because destination already exists.", (Object)src, (Object)dst);
            return false;
        }
        return this.copyObject(this.stripPrefixIfPresent(src), this.stripPrefixIfPresent(dst)) && this.deleteObject(this.stripPrefixIfPresent(src));
    }

    @Override
    public boolean renameRenamableFile(String src, String dst) throws IOException {
        return this.retryOnFalse(() -> this.renameFile(src, dst), () -> "rename file from " + src + " to " + dst);
    }

    @Override
    public boolean supportsFlush() throws IOException {
        return false;
    }

    @VisibleForTesting
    public abstract boolean createEmptyObject(String var1);

    protected abstract OutputStream createObject(String var1) throws IOException;

    protected String convertToFolderName(String key) {
        key = CommonUtils.stripSuffixIfPresent(key, PATH_SEPARATOR);
        return key + this.getFolderSuffix();
    }

    protected abstract boolean copyObject(String var1, String var2) throws IOException;

    protected abstract boolean deleteObject(String var1) throws IOException;

    protected List<String> deleteObjects(List<String> keys) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : keys) {
            boolean status = this.deleteObject(key);
            if (!status && !key.endsWith(this.getFolderSuffix())) continue;
            result.add(key);
        }
        return result;
    }

    protected abstract ObjectPermissions getPermissions();

    protected int getListingChunkLengthMax() {
        return 1000;
    }

    protected int getListingChunkLength(AlluxioConfiguration conf) {
        return Math.min(conf.getInt(PropertyKey.UNDERFS_LISTING_LENGTH), this.getListingChunkLengthMax());
    }

    @Nullable
    protected abstract ObjectStatus getObjectStatus(String var1) throws IOException;

    @Nullable
    protected String getParentPath(String path) {
        if (this.isRoot(path)) {
            return null;
        }
        int separatorIndex = path.lastIndexOf(PATH_SEPARATOR);
        if (separatorIndex < 0) {
            return null;
        }
        return path.substring(0, separatorIndex);
    }

    protected boolean isRoot(String path) {
        String normalizePath = PathUtils.normalizePath(path, PATH_SEPARATOR);
        return normalizePath.equals(PATH_SEPARATOR) || normalizePath.equals(PathUtils.normalizePath(this.mRootKeySupplier.get(), PATH_SEPARATOR));
    }

    protected String getChildName(String child, String parent) throws IOException {
        if (child.startsWith(parent)) {
            return child.substring(parent.length());
        }
        throw new IOException(MessageFormat.format("Parent path \"{0}\" is not a prefix of child {1}.", parent, child));
    }

    protected abstract String getFolderSuffix();

    @Nullable
    protected ObjectListingChunk getObjectListingChunk(String key, boolean recursive, String startAfter, int batchSize) throws IOException {
        if (startAfter == null && batchSize == 0) {
            return this.getObjectListingChunk(key, recursive);
        }
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Nullable
    protected abstract ObjectListingChunk getObjectListingChunk(String var1, boolean var2) throws IOException;

    protected ObjectListingChunk getObjectListingChunkForPath(String path, boolean recursive) throws IOException {
        return this.getObjectListingChunkForPath(path, recursive, null, 0);
    }

    @Nullable
    protected ObjectListingChunk getObjectListingChunkForPath(String path, boolean recursive, String startAfter, int batchSize) throws IOException {
        String dir = this.stripPrefixIfPresent(path);
        ObjectListingChunk objs = this.getObjectListingChunk(dir, recursive, startAfter, batchSize);
        if (objs != null && (objs.getObjectStatuses() != null && objs.getObjectStatuses().length > 0 || objs.getCommonPrefixes() != null && objs.getCommonPrefixes().length > 0)) {
            String folderName = this.convertToFolderName(dir);
            if (!this.mUfsConf.isReadOnly() && this.mBreadcrumbsEnabled && !this.isRoot(dir) && Arrays.stream(objs.getObjectStatuses()).noneMatch(x -> ((ObjectStatus)x).mContentLength == 0L && x.getName().equals(folderName))) {
                this.mkdirsInternal(dir);
            }
            return objs;
        }
        return null;
    }

    private void populateUfsStatus(String keyPrefix, ObjectListingChunk chunk, boolean isRecursive, Map<String, UfsStatus> ufsStatusMap) throws IOException {
        String[] commonPrefixes;
        for (ObjectStatus status : chunk.getObjectStatuses()) {
            String child = this.getChildName(status.getName(), keyPrefix);
            if (child.isEmpty() || child.equals(this.getFolderSuffix())) continue;
            ObjectPermissions permissions = this.getPermissions();
            if (child.endsWith(this.getFolderSuffix())) {
                child = CommonUtils.stripSuffixIfPresent(child, this.getFolderSuffix());
                ufsStatusMap.put(child, new UfsDirectoryStatus(child, permissions.getOwner(), permissions.getGroup(), permissions.getMode()));
                continue;
            }
            ufsStatusMap.put(child, new UfsFileStatus(child, status.getContentHash(), status.getContentLength(), status.getLastModifiedTimeMs(), permissions.getOwner(), permissions.getGroup(), permissions.getMode(), this.mUfsConf.getBytes(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT)));
        }
        if (isRecursive) {
            HashSet<String> prefixes = new HashSet<String>();
            for (ObjectStatus objectStatus : chunk.getObjectStatuses()) {
                String objectName = objectStatus.getName();
                while (objectName.startsWith(keyPrefix) && objectName.contains(PATH_SEPARATOR)) {
                    if ((objectName = objectName.substring(0, objectName.lastIndexOf(PATH_SEPARATOR))).isEmpty()) continue;
                    prefixes.add(PathUtils.normalizePath(objectName, PATH_SEPARATOR));
                }
            }
            commonPrefixes = prefixes.toArray(new String[0]);
        } else {
            commonPrefixes = chunk.getCommonPrefixes();
        }
        for (String commonPrefix : commonPrefixes) {
            if (!commonPrefix.startsWith(keyPrefix)) continue;
            String child = this.getChildName(commonPrefix, keyPrefix);
            int childNameIndex = child.lastIndexOf(PATH_SEPARATOR);
            String string = child = childNameIndex != -1 ? child.substring(0, childNameIndex) : child;
            if (child.isEmpty() || ufsStatusMap.containsKey(child)) continue;
            ObjectPermissions permissions = this.getPermissions();
            ufsStatusMap.put(child, new UfsDirectoryStatus(child, permissions.getOwner(), permissions.getGroup(), permissions.getMode()));
        }
    }

    protected abstract String getRootKey();

    @Nullable
    protected UfsStatus[] listInternal(String path, ListOptions options) throws IOException {
        ObjectListingChunk chunk = this.getObjectListingChunkForPath(path, options.isRecursive());
        if (chunk == null) {
            String keyAsFolder = this.convertToFolderName(this.stripPrefixIfPresent(path));
            if (this.getObjectStatus(keyAsFolder) != null) {
                return new UfsStatus[0];
            }
            return null;
        }
        String keyPrefix = PathUtils.normalizePath(this.stripPrefixIfPresent(path), PATH_SEPARATOR);
        keyPrefix = keyPrefix.equals(PATH_SEPARATOR) ? "" : keyPrefix;
        HashMap<String, UfsStatus> children = new HashMap<String, UfsStatus>();
        while (chunk != null) {
            this.populateUfsStatus(keyPrefix, chunk, options.isRecursive(), children);
            chunk = chunk.getNextChunk();
        }
        UfsStatus[] ret = new UfsStatus[children.size()];
        int pos = 0;
        for (UfsStatus status : children.values()) {
            ret[pos++] = status;
        }
        return ret;
    }

    protected boolean mkdirsInternal(String key) {
        return this.createEmptyObject(this.convertToFolderName(this.stripPrefixIfPresent(key)));
    }

    protected abstract InputStream openObject(String var1, OpenOptions var2, RetryPolicy var3) throws IOException;

    protected boolean parentExists(String path) throws IOException {
        if (this.isRoot(path)) {
            return true;
        }
        String parentKey = this.getParentPath(path);
        return parentKey != null && this.isDirectory(parentKey);
    }

    @VisibleForTesting
    public String stripPrefixIfPresent(String path) {
        if (this.mRootKeySupplier.get().equals(path)) {
            return "";
        }
        String stripedKey = CommonUtils.stripPrefixIfPresent(path, PathUtils.normalizePath(this.mRootKeySupplier.get(), PATH_SEPARATOR));
        if (!stripedKey.equals(path)) {
            return stripedKey;
        }
        return CommonUtils.stripPrefixIfPresent(path, PATH_SEPARATOR);
    }

    private void handleRetriablException(IOException e) throws IOException {
        if (e instanceof EOFException || e instanceof UnknownHostException || e instanceof ConnectTimeoutException) {
            LOG.warn("retry policy meet exception, and will retry, e:", (Throwable)e);
            return;
        }
        if (e instanceof SocketException) {
            LOG.warn("retry policy meet socket exception, and will retry, e:", (Throwable)e);
            return;
        }
        LOG.warn("retry policy meet exception, but no need to retry, e:", (Throwable)e);
        throw e;
    }

    @VisibleForTesting
    protected <T> T retryOnException(ObjectStoreOperation<T> op, Supplier<String> description) throws IOException {
        RetryPolicy retryPolicy = this.getRetryPolicy();
        IOException thrownException = null;
        while (retryPolicy.attempt()) {
            try {
                return op.apply();
            }
            catch (IOException e) {
                LOG.debug("Attempt {} to {} failed with exception : {}", new Object[]{retryPolicy.getAttemptCount(), description.get(), e.toString()});
                this.handleRetriablException(e);
                thrownException = e;
            }
        }
        throw thrownException;
    }

    private boolean retryOnFalse(ObjectStoreOperation<Boolean> op, Supplier<String> description) throws IOException {
        RetryPolicy retryPolicy = this.getRetryPolicy();
        while (retryPolicy.attempt()) {
            if (op.apply().booleanValue()) {
                return true;
            }
            LOG.debug("Failed in attempt {} to {} ", (Object)retryPolicy.getAttemptCount(), (Object)description.get());
        }
        return false;
    }

    private RetryPolicy getRetryPolicy() {
        return new ExponentialBackoffRetry((int)this.mUfsConf.getMs(PropertyKey.UNDERFS_EVENTUAL_CONSISTENCY_RETRY_BASE_SLEEP_MS), (int)this.mUfsConf.getMs(PropertyKey.UNDERFS_EVENTUAL_CONSISTENCY_RETRY_MAX_SLEEP_MS), this.mUfsConf.getInt(PropertyKey.UNDERFS_EVENTUAL_CONSISTENCY_RETRY_MAX_NUM));
    }

    private RetryPolicy getRetryOncePolicy() {
        return new CountingRetry(1);
    }

    @VisibleForTesting
    protected static interface ObjectStoreOperation<T> {
        public T apply() throws IOException;
    }

    public class UfsStatusIterator
    implements Iterator<UfsStatus> {
        private ObjectListingChunk mChunk;
        private final String mKeyPrefix;
        private final boolean mIsRecursive;
        private Iterator<UfsStatus> mIterator = null;
        private String mLastKey = null;

        public UfsStatusIterator(String path, boolean isRecursive, ObjectListingChunk firstChunk) throws IOException {
            String keyPrefix = PathUtils.normalizePath(ObjectUnderFileSystem.this.stripPrefixIfPresent(path), PATH_SEPARATOR);
            this.mKeyPrefix = keyPrefix = keyPrefix.equals(PATH_SEPARATOR) ? "" : keyPrefix;
            this.mIsRecursive = isRecursive;
            this.mChunk = firstChunk;
            this.updateIterator();
        }

        private void updateIterator() throws IOException {
            NavigableMap ufsStatusMap = new TreeMap();
            ObjectUnderFileSystem.this.populateUfsStatus(this.mKeyPrefix, this.mChunk, this.mIsRecursive, ufsStatusMap);
            if (this.mLastKey != null) {
                ufsStatusMap = ufsStatusMap.tailMap(this.mLastKey, false);
            }
            this.mIterator = Iterators.transform(ufsStatusMap.entrySet().iterator(), Map.Entry::getValue);
            this.mLastKey = ufsStatusMap.isEmpty() ? null : (String)ufsStatusMap.lastKey();
        }

        @Override
        public boolean hasNext() {
            if (this.mChunk == null) {
                return false;
            }
            if (this.mIterator.hasNext()) {
                return true;
            }
            if (Boolean.FALSE.equals(this.mChunk.hasNextChunk())) {
                return false;
            }
            try {
                this.mChunk = this.mChunk.getNextChunk();
                this.updateIterator();
                return this.hasNext();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public UfsStatus next() {
            return this.mIterator.next();
        }
    }

    @ThreadSafe
    protected class RenameBuffer
    extends OperationBuffer<Pair<String, String>> {
        private final DeleteBuffer mDeleteBuffer;

        public RenameBuffer(DeleteBuffer deleteBuffer) {
            this.mDeleteBuffer = deleteBuffer;
        }

        @Override
        protected int getBatchSize() {
            return 1;
        }

        @Override
        protected List<Pair<String, String>> operate(List<Pair<String, String>> paths) throws IOException {
            ArrayList<Pair<String, String>> succeeded = new ArrayList<Pair<String, String>>();
            for (Pair<String, String> pathPair : paths) {
                String dst;
                String src = ObjectUnderFileSystem.this.stripPrefixIfPresent(pathPair.getFirst());
                if (!ObjectUnderFileSystem.this.copyObject(src, dst = ObjectUnderFileSystem.this.stripPrefixIfPresent(pathPair.getSecond()))) continue;
                this.mDeleteBuffer.add(src);
                succeeded.add(pathPair);
            }
            return succeeded;
        }
    }

    @ThreadSafe
    protected class DeleteBuffer
    extends OperationBuffer<String> {
        @Override
        protected int getBatchSize() {
            return ObjectUnderFileSystem.this.getListingChunkLength(ObjectUnderFileSystem.this.mUfsConf);
        }

        @Override
        protected List<String> operate(List<String> paths) throws IOException {
            return ObjectUnderFileSystem.this.deleteObjects(paths);
        }
    }

    @ThreadSafe
    protected abstract class OperationBuffer<T> {
        private final ArrayList<Future<List<T>>> mBatchesResult = new ArrayList();
        private final List<T> mCurrentBatchBuffer = new ArrayList<T>();
        protected int mEntriesAdded = 0;

        protected OperationBuffer() {
        }

        protected abstract int getBatchSize();

        protected abstract List<T> operate(List<T> var1) throws IOException;

        public synchronized void add(T input) throws IOException {
            if (this.mCurrentBatchBuffer.size() == this.getBatchSize()) {
                this.submitBatch();
            }
            this.mCurrentBatchBuffer.add(input);
            ++this.mEntriesAdded;
        }

        public synchronized List<T> getResult() throws IOException {
            this.submitBatch();
            ArrayList result = new ArrayList();
            for (Future<List<T>> list : this.mBatchesResult) {
                try {
                    result.addAll(list.get());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOG.warn("{}: Interrupted while waiting for the result of batch operation. UFS and Alluxio state may be inconsistent. Error: {}", (Object)this.getClass().getName(), (Object)e.getMessage());
                }
                catch (ExecutionException e) {
                    LOG.warn("{}: A batch operation failed. UFS and Alluxio state may be inconsistent. Error: {}", (Object)this.getClass().getName(), (Object)e.getMessage());
                }
            }
            return result;
        }

        private void submitBatch() throws IOException {
            if (this.mCurrentBatchBuffer.size() != 0) {
                ArrayList<T> batch = new ArrayList<T>(this.mCurrentBatchBuffer);
                this.mCurrentBatchBuffer.clear();
                this.mBatchesResult.add(ObjectUnderFileSystem.this.mExecutorService.submit(() -> {
                    try {
                        return this.operate(batch);
                    }
                    catch (IOException e) {
                        LOG.error("A batch operation failed. ", (Throwable)e);
                        return Collections.emptyList();
                    }
                }));
            }
        }
    }

    public static class ObjectPermissions {
        final String mOwner;
        final String mGroup;
        final short mMode;

        public ObjectPermissions(String owner, String group, short mode) {
            this.mOwner = owner;
            this.mGroup = group;
            this.mMode = mode;
        }

        public String getOwner() {
            return this.mOwner;
        }

        public String getGroup() {
            return this.mGroup;
        }

        public short getMode() {
            return this.mMode;
        }
    }

    public static interface ObjectListingChunk {
        public ObjectStatus[] getObjectStatuses();

        public String[] getCommonPrefixes();

        @Nullable
        public ObjectListingChunk getNextChunk() throws IOException;

        @Nullable
        default public Boolean hasNextChunk() {
            throw new UnsupportedOperationException("HasNextChunk not implemented for " + this.getClass().getName());
        }
    }

    protected static class ObjectStatus {
        private static final long INVALID_CONTENT_LENGTH = -1L;
        private final String mContentHash;
        private final long mContentLength;
        private final Long mLastModifiedTimeMs;
        private final String mName;

        public ObjectStatus(String name, String contentHash, long contentLength, @Nullable Long lastModifiedTimeMs) {
            this.mContentHash = contentHash == null ? "" : contentHash;
            this.mContentLength = contentLength;
            this.mLastModifiedTimeMs = lastModifiedTimeMs;
            this.mName = name;
        }

        public ObjectStatus(String name) {
            this.mContentHash = "";
            this.mContentLength = -1L;
            this.mLastModifiedTimeMs = null;
            this.mName = name;
        }

        public String getContentHash() {
            return this.mContentHash;
        }

        public long getContentLength() {
            return this.mContentLength;
        }

        @Nullable
        public Long getLastModifiedTimeMs() {
            return this.mLastModifiedTimeMs;
        }

        public String getName() {
            return this.mName;
        }
    }
}

