/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.exception.runtime.FailedPreconditionRuntimeException;
import alluxio.util.CommonUtils;
import alluxio.util.EnvironmentUtils;
import alluxio.util.OSUtils;
import com.amazonaws.util.EC2MetadataUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

@ThreadSafe
public final class UpdateCheckUtils {
    public static final String USER_AGENT_SEPARATOR = ";";
    static final String PRODUCT_CODE_FORMAT = "ProductCode:%s";
    static final String OS_FORMAT = "OS:%s";
    static final String CFT_KEY = "cft";
    static final String DOCKER_KEY = "docker";
    static final String EC2_KEY = "ec2";
    static final String EMR_KEY = "emr";
    static final String GCE_KEY = "gce";
    static final String KUBERNETES_KEY = "kubernetes";

    public static String getLatestVersion(String id, CommonUtils.ProcessType processType, List<String> additionalInfo) throws IOException {
        Preconditions.checkState((id != null && !id.isEmpty() ? 1 : 0) != 0, (Object)"id should not be null or empty");
        Preconditions.checkNotNull(additionalInfo);
        Joiner joiner = Joiner.on((String)"/");
        String path = joiner.join((Object)"v1", (Object)"version", new Object[0]);
        String url = new URL(new URL("https://diagnostics.alluxio.io"), path).toString();
        HttpGet post = new HttpGet(url);
        post.setHeader("User-Agent", UpdateCheckUtils.getUserAgentString(id, processType, additionalInfo));
        post.setHeader("Authorization", "Basic YWxsdXhpbzp0YWNoeW9u");
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(3000).setConnectTimeout(3000).setSocketTimeout(3000).build()).build();
        HttpResponse response = client.execute((HttpUriRequest)post);
        int responseCode = response.getStatusLine().getStatusCode();
        if (responseCode != 200) {
            throw new FailedPreconditionRuntimeException("Update check request failed with code: " + responseCode);
        }
        return EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
    }

    @VisibleForTesting
    public static String getUserAgentString(String id, CommonUtils.ProcessType processType, List<String> additionalInfo) {
        ArrayList<String> info = new ArrayList<String>();
        info.add(id);
        UpdateCheckUtils.addUserAgentEnvironments(info);
        info.addAll(additionalInfo);
        info.add(String.format("processType:%s", processType.toString()));
        return String.format("Alluxio/%s (%s)", "309", Joiner.on((String)"; ").skipNulls().join(info));
    }

    @VisibleForTesting
    public static void addUserAgentEnvironments(List<String> info) {
        info.add(String.format(OS_FORMAT, OSUtils.OS_NAME));
        if (EnvironmentUtils.isDocker()) {
            info.add(DOCKER_KEY);
        }
        if (EnvironmentUtils.isKubernetes()) {
            info.add(KUBERNETES_KEY);
        }
        if (EnvironmentUtils.isGoogleComputeEngine()) {
            info.add(GCE_KEY);
        } else {
            UpdateCheckUtils.addEC2Info(info);
        }
    }

    private static void addEC2Info(List<String> info) {
        boolean isEC2 = false;
        String productCode = EnvironmentUtils.getEC2ProductCode();
        if (!productCode.isEmpty()) {
            info.add(String.format(PRODUCT_CODE_FORMAT, productCode));
            isEC2 = true;
        }
        String userData = "";
        try {
            userData = EC2MetadataUtils.getUserData();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (userData != null && !userData.isEmpty()) {
            isEC2 = true;
            if (EnvironmentUtils.isCFT(userData)) {
                info.add(CFT_KEY);
            } else if (EnvironmentUtils.isEMR(userData)) {
                info.add(EMR_KEY);
            }
        } else if (!isEC2 && EnvironmentUtils.isEC2()) {
            isEC2 = true;
        }
        if (isEC2) {
            info.add(EC2_KEY);
        }
    }

    private UpdateCheckUtils() {
    }
}

