/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc;

import io.airlift.units.DataSize;
import io.trino.orc.OrcCorruptionException;
import io.trino.orc.OrcDataSourceId;
import io.trino.orc.OrcLz4Decompressor;
import io.trino.orc.OrcSnappyDecompressor;
import io.trino.orc.OrcZlibDecompressor;
import io.trino.orc.OrcZstdDecompressor;
import io.trino.orc.metadata.CompressionKind;
import java.util.Optional;

public interface OrcDecompressor {
    public static final int MAX_BUFFER_SIZE = Math.toIntExact(DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());

    public static Optional<OrcDecompressor> createOrcDecompressor(OrcDataSourceId orcDataSourceId, CompressionKind compression, int bufferSize) throws OrcCorruptionException {
        if (compression != CompressionKind.NONE && (bufferSize <= 0 || bufferSize > MAX_BUFFER_SIZE)) {
            throw new OrcCorruptionException(orcDataSourceId, "Invalid compression block size: " + bufferSize);
        }
        switch (compression) {
            case NONE: {
                return Optional.empty();
            }
            case ZLIB: {
                return Optional.of(new OrcZlibDecompressor(orcDataSourceId, bufferSize));
            }
            case SNAPPY: {
                return Optional.of(new OrcSnappyDecompressor(orcDataSourceId, bufferSize));
            }
            case LZ4: {
                return Optional.of(new OrcLz4Decompressor(orcDataSourceId, bufferSize));
            }
            case ZSTD: {
                return Optional.of(new OrcZstdDecompressor(orcDataSourceId, bufferSize));
            }
        }
        throw new OrcCorruptionException(orcDataSourceId, "Unknown compression type: " + String.valueOf((Object)compression));
    }

    public int decompress(byte[] var1, int var2, int var3, OutputBuffer var4) throws OrcCorruptionException;

    public static interface OutputBuffer {
        public byte[] initialize(int var1);

        public byte[] grow(int var1);
    }
}

