/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.metadata.statistics;

import com.google.common.base.MoreObjects;
import io.airlift.slice.SizeOf;
import io.trino.orc.metadata.statistics.BinaryStatistics;
import io.trino.orc.metadata.statistics.BinaryStatisticsBuilder;
import io.trino.orc.metadata.statistics.BloomFilter;
import io.trino.orc.metadata.statistics.BooleanStatistics;
import io.trino.orc.metadata.statistics.BooleanStatisticsBuilder;
import io.trino.orc.metadata.statistics.DateStatistics;
import io.trino.orc.metadata.statistics.DateStatisticsBuilder;
import io.trino.orc.metadata.statistics.DecimalStatistics;
import io.trino.orc.metadata.statistics.DoubleStatistics;
import io.trino.orc.metadata.statistics.DoubleStatisticsBuilder;
import io.trino.orc.metadata.statistics.IntegerStatistics;
import io.trino.orc.metadata.statistics.IntegerStatisticsBuilder;
import io.trino.orc.metadata.statistics.LongDecimalStatisticsBuilder;
import io.trino.orc.metadata.statistics.StatisticsHasher;
import io.trino.orc.metadata.statistics.StringStatistics;
import io.trino.orc.metadata.statistics.StringStatisticsBuilder;
import io.trino.orc.metadata.statistics.TimestampStatistics;
import io.trino.orc.metadata.statistics.TimestampStatisticsBuilder;
import java.util.List;
import java.util.Objects;

public class ColumnStatistics
implements StatisticsHasher.Hashable {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(ColumnStatistics.class);
    private final boolean hasNumberOfValues;
    private final long numberOfValues;
    private final long minAverageValueSizeInBytes;
    private final BooleanStatistics booleanStatistics;
    private final IntegerStatistics integerStatistics;
    private final DoubleStatistics doubleStatistics;
    private final long numberOfNanValues;
    private final StringStatistics stringStatistics;
    private final DateStatistics dateStatistics;
    private final TimestampStatistics timestampStatistics;
    private final DecimalStatistics decimalStatistics;
    private final BinaryStatistics binaryStatistics;
    private final BloomFilter bloomFilter;

    public ColumnStatistics(Long numberOfValues, long minAverageValueSizeInBytes, BooleanStatistics booleanStatistics, IntegerStatistics integerStatistics, DoubleStatistics doubleStatistics, Long numberOfNanValues, StringStatistics stringStatistics, DateStatistics dateStatistics, TimestampStatistics timestampStatistics, DecimalStatistics decimalStatistics, BinaryStatistics binaryStatistics, BloomFilter bloomFilter) {
        this.hasNumberOfValues = numberOfValues != null;
        this.numberOfValues = this.hasNumberOfValues ? numberOfValues : 0L;
        this.minAverageValueSizeInBytes = minAverageValueSizeInBytes;
        this.booleanStatistics = booleanStatistics;
        this.integerStatistics = integerStatistics;
        this.doubleStatistics = doubleStatistics;
        this.numberOfNanValues = numberOfNanValues != null ? numberOfNanValues : 0L;
        this.stringStatistics = stringStatistics;
        this.dateStatistics = dateStatistics;
        this.timestampStatistics = timestampStatistics;
        this.decimalStatistics = decimalStatistics;
        this.binaryStatistics = binaryStatistics;
        this.bloomFilter = bloomFilter;
    }

    public boolean hasNumberOfValues() {
        return this.hasNumberOfValues;
    }

    public long getNumberOfValues() {
        return this.hasNumberOfValues ? this.numberOfValues : 0L;
    }

    public boolean hasMinAverageValueSizeInBytes() {
        return this.hasNumberOfValues() && this.numberOfValues > 0L;
    }

    public long getMinAverageValueSizeInBytes() {
        return this.minAverageValueSizeInBytes;
    }

    public BooleanStatistics getBooleanStatistics() {
        return this.booleanStatistics;
    }

    public DateStatistics getDateStatistics() {
        return this.dateStatistics;
    }

    public DoubleStatistics getDoubleStatistics() {
        return this.doubleStatistics;
    }

    public long getNumberOfNanValues() {
        return this.numberOfNanValues;
    }

    public IntegerStatistics getIntegerStatistics() {
        return this.integerStatistics;
    }

    public StringStatistics getStringStatistics() {
        return this.stringStatistics;
    }

    public DecimalStatistics getDecimalStatistics() {
        return this.decimalStatistics;
    }

    public BinaryStatistics getBinaryStatistics() {
        return this.binaryStatistics;
    }

    public TimestampStatistics getTimestampStatistics() {
        return this.timestampStatistics;
    }

    public BloomFilter getBloomFilter() {
        return this.bloomFilter;
    }

    public ColumnStatistics withBloomFilter(BloomFilter bloomFilter) {
        return new ColumnStatistics(this.getNumberOfValues(), this.minAverageValueSizeInBytes, this.booleanStatistics, this.integerStatistics, this.doubleStatistics, this.numberOfNanValues, this.stringStatistics, this.dateStatistics, this.timestampStatistics, this.decimalStatistics, this.binaryStatistics, bloomFilter);
    }

    public long getRetainedSizeInBytes() {
        long retainedSizeInBytes = INSTANCE_SIZE;
        if (this.booleanStatistics != null) {
            retainedSizeInBytes += this.booleanStatistics.getRetainedSizeInBytes();
        }
        if (this.integerStatistics != null) {
            retainedSizeInBytes += this.integerStatistics.getRetainedSizeInBytes();
        }
        if (this.doubleStatistics != null) {
            retainedSizeInBytes += this.doubleStatistics.getRetainedSizeInBytes();
        }
        if (this.stringStatistics != null) {
            retainedSizeInBytes += this.stringStatistics.getRetainedSizeInBytes();
        }
        if (this.dateStatistics != null) {
            retainedSizeInBytes += this.dateStatistics.getRetainedSizeInBytes();
        }
        if (this.timestampStatistics != null) {
            retainedSizeInBytes += this.timestampStatistics.getRetainedSizeInBytes();
        }
        if (this.decimalStatistics != null) {
            retainedSizeInBytes += this.decimalStatistics.getRetainedSizeInBytes();
        }
        if (this.binaryStatistics != null) {
            retainedSizeInBytes += this.binaryStatistics.getRetainedSizeInBytes();
        }
        if (this.bloomFilter != null) {
            retainedSizeInBytes += this.bloomFilter.getRetainedSizeInBytes();
        }
        return retainedSizeInBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnStatistics that = (ColumnStatistics)o;
        return Objects.equals(this.hasNumberOfValues, that.hasNumberOfValues) && Objects.equals(this.getNumberOfValues(), that.getNumberOfValues()) && Objects.equals(this.booleanStatistics, that.booleanStatistics) && Objects.equals(this.integerStatistics, that.integerStatistics) && Objects.equals(this.doubleStatistics, that.doubleStatistics) && Objects.equals(this.stringStatistics, that.stringStatistics) && Objects.equals(this.dateStatistics, that.dateStatistics) && Objects.equals(this.timestampStatistics, that.timestampStatistics) && Objects.equals(this.decimalStatistics, that.decimalStatistics) && Objects.equals(this.binaryStatistics, that.binaryStatistics) && Objects.equals(this.bloomFilter, that.bloomFilter);
    }

    public int hashCode() {
        return Objects.hash(this.hasNumberOfValues, this.getNumberOfValues(), this.booleanStatistics, this.integerStatistics, this.doubleStatistics, this.stringStatistics, this.dateStatistics, this.timestampStatistics, this.decimalStatistics, this.binaryStatistics, this.bloomFilter);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("numberOfValues", this.getNumberOfValues()).add("booleanStatistics", (Object)this.booleanStatistics).add("integerStatistics", (Object)this.integerStatistics).add("doubleStatistics", (Object)this.doubleStatistics).add("stringStatistics", (Object)this.stringStatistics).add("dateStatistics", (Object)this.dateStatistics).add("timestampStatistics", (Object)this.timestampStatistics).add("decimalStatistics", (Object)this.decimalStatistics).add("binaryStatistics", (Object)this.binaryStatistics).add("bloomFilter", (Object)this.bloomFilter).toString();
    }

    @Override
    public void addHash(StatisticsHasher hasher) {
        hasher.putOptionalLong(this.hasNumberOfValues, this.numberOfValues).putOptionalHashable(this.booleanStatistics).putOptionalHashable(this.integerStatistics).putOptionalHashable(this.doubleStatistics).putOptionalHashable(this.stringStatistics).putOptionalHashable(this.dateStatistics).putOptionalHashable(this.timestampStatistics).putOptionalHashable(this.decimalStatistics).putOptionalHashable(this.binaryStatistics).putOptionalHashable(this.bloomFilter);
    }

    public static ColumnStatistics mergeColumnStatistics(List<ColumnStatistics> stats) {
        long numberOfRows = stats.stream().mapToLong(ColumnStatistics::getNumberOfValues).sum();
        long minAverageValueBytes = 0L;
        if (numberOfRows > 0L) {
            minAverageValueBytes = stats.stream().mapToLong(s -> s.getMinAverageValueSizeInBytes() * s.getNumberOfValues()).sum() / numberOfRows;
        }
        long numberOfNanValues = stats.stream().mapToLong(ColumnStatistics::getNumberOfNanValues).sum();
        return new ColumnStatistics(numberOfRows, minAverageValueBytes, BooleanStatisticsBuilder.mergeBooleanStatistics(stats).orElse(null), IntegerStatisticsBuilder.mergeIntegerStatistics(stats).orElse(null), DoubleStatisticsBuilder.mergeDoubleStatistics(stats).orElse(null), numberOfNanValues, StringStatisticsBuilder.mergeStringStatistics(stats).orElse(null), DateStatisticsBuilder.mergeDateStatistics(stats).orElse(null), TimestampStatisticsBuilder.mergeTimestampStatistics(stats).orElse(null), LongDecimalStatisticsBuilder.mergeDecimalStatistics(stats).orElse(null), BinaryStatisticsBuilder.mergeBinaryStatistics(stats).orElse(null), null);
    }
}

