/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.reader;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closer;
import io.airlift.slice.SizeOf;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.orc.OrcBlockFactory;
import io.trino.orc.OrcColumn;
import io.trino.orc.OrcCorruptionException;
import io.trino.orc.OrcReader;
import io.trino.orc.metadata.ColumnEncoding;
import io.trino.orc.metadata.ColumnMetadata;
import io.trino.orc.metadata.Stream;
import io.trino.orc.reader.ColumnReader;
import io.trino.orc.reader.ColumnReaders;
import io.trino.orc.reader.ReaderUtils;
import io.trino.orc.stream.BooleanInputStream;
import io.trino.orc.stream.InputStreamSource;
import io.trino.orc.stream.InputStreamSources;
import io.trino.orc.stream.MissingInputStreamSource;
import io.trino.spi.block.Block;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.LazyBlockLoader;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class StructColumnReader
implements ColumnReader {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(StructColumnReader.class);
    private final OrcColumn column;
    private final OrcBlockFactory blockFactory;
    private final Map<String, ColumnReader> structFields;
    private final RowType type;
    private final ImmutableList<String> fieldNames;
    private int readOffset;
    private int nextBatchSize;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private boolean rowGroupOpen;

    StructColumnReader(Type type, OrcColumn column, OrcReader.ProjectedLayout readLayout, AggregatedMemoryContext memoryContext, OrcBlockFactory blockFactory, OrcReader.FieldMapperFactory fieldMapperFactory) throws OrcCorruptionException {
        Objects.requireNonNull(type, "type is null");
        ReaderUtils.verifyStreamType(column, type, RowType.class::isInstance);
        this.type = (RowType)type;
        this.column = Objects.requireNonNull(column, "column is null");
        this.blockFactory = Objects.requireNonNull(blockFactory, "blockFactory is null");
        OrcReader.FieldMapper fieldMapper = fieldMapperFactory.create(column);
        ImmutableList.Builder fieldNames = ImmutableList.builder();
        ImmutableMap.Builder structFields = ImmutableMap.builder();
        for (RowType.Field field : this.type.getFields()) {
            OrcReader.ProjectedLayout fieldLayout;
            String fieldName = ((String)field.getName().orElseThrow(() -> new IllegalArgumentException("ROW type does not have field names declared: " + String.valueOf(type)))).toLowerCase(Locale.ENGLISH);
            fieldNames.add((Object)fieldName);
            OrcColumn fieldStream = fieldMapper.get(fieldName);
            if (fieldStream == null || (fieldLayout = readLayout.getFieldLayout(fieldStream)) == null) continue;
            structFields.put((Object)fieldName, (Object)ColumnReaders.createColumnReader(field.getType(), fieldStream, fieldLayout, memoryContext, blockFactory, fieldMapperFactory));
        }
        this.fieldNames = fieldNames.build();
        this.structFields = structFields.buildOrThrow();
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock() throws IOException {
        Block[] blocks;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            for (ColumnReader structField : this.structFields.values()) {
                structField.prepareNextRead(this.readOffset);
            }
        }
        boolean[] nullVector = null;
        if (this.presentStream == null) {
            blocks = this.getBlocks(this.nextBatchSize, this.nextBatchSize, null);
        } else {
            nullVector = new boolean[this.nextBatchSize];
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, nullVector);
            if (nullValues != this.nextBatchSize) {
                blocks = this.getBlocks(this.nextBatchSize, this.nextBatchSize - nullValues, nullVector);
            } else {
                List typeParameters = this.type.getTypeParameters();
                blocks = new Block[typeParameters.size()];
                for (int i = 0; i < typeParameters.size(); ++i) {
                    blocks[i] = RunLengthEncodedBlock.create((Block)((Type)typeParameters.get(i)).createBlockBuilder(null, 0).appendNull().build(), (int)this.nextBatchSize);
                }
            }
        }
        Verify.verify((Arrays.stream(blocks).mapToInt(Block::getPositionCount).distinct().count() == 1L ? 1 : 0) != 0);
        RowBlock rowBlock = RowBlock.fromNotNullSuppressedFieldBlocks((int)this.nextBatchSize, Optional.ofNullable(nullVector), (Block[])blocks);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return rowBlock;
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(ZoneId fileTimeZone, InputStreamSources dictionaryStreamSources, ColumnMetadata<ColumnEncoding> encoding) throws IOException {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.rowGroupOpen = false;
        for (ColumnReader structField : this.structFields.values()) {
            structField.startStripe(fileTimeZone, dictionaryStreamSources, encoding);
        }
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.column, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.rowGroupOpen = false;
        for (ColumnReader structField : this.structFields.values()) {
            structField.startRowGroup(dataStreamSources);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.column).toString();
    }

    private Block[] getBlocks(int positionCount, int nonNullCount, boolean[] nullVector) {
        Block[] blocks = new Block[this.fieldNames.size()];
        for (int i = 0; i < this.fieldNames.size(); ++i) {
            String fieldName = (String)this.fieldNames.get(i);
            ColumnReader columnReader = this.structFields.get(fieldName);
            if (columnReader != null) {
                columnReader.prepareNextRead(nonNullCount);
                LazyBlockLoader lazyBlockLoader = this.blockFactory.createLazyBlockLoader(columnReader::readBlock, true);
                if (nullVector == null) {
                    blocks[i] = new LazyBlock(positionCount, lazyBlockLoader);
                    continue;
                }
                blocks[i] = new LazyBlock(positionCount, () -> ReaderUtils.toNotNullSupressedBlock(positionCount, nullVector, lazyBlockLoader.load()));
                continue;
            }
            blocks[i] = RunLengthEncodedBlock.create((Type)((RowType.Field)this.type.getFields().get(i)).getType(), null, (int)positionCount);
        }
        return blocks;
    }

    @Override
    public void close() {
        try (Closer closer = Closer.create();){
            for (ColumnReader structField : this.structFields.values()) {
                closer.register(structField::close);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        long retainedSizeInBytes = INSTANCE_SIZE;
        for (ColumnReader structField : this.structFields.values()) {
            retainedSizeInBytes += structField.getRetainedSizeInBytes();
        }
        return retainedSizeInBytes;
    }
}

