/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import io.trino.plugin.hive.HiveBasicStatistics;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.metastore.BooleanStatistics;
import io.trino.plugin.hive.metastore.DateStatistics;
import io.trino.plugin.hive.metastore.DecimalStatistics;
import io.trino.plugin.hive.metastore.DoubleStatistics;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.IntegerStatistics;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;

public enum StatisticsUpdateMode {
    OVERWRITE_ALL{

        @Override
        public PartitionStatistics updatePartitionStatistics(PartitionStatistics oldPartitionStats, PartitionStatistics newPartitionStats) {
            return newPartitionStats;
        }
    }
    ,
    OVERWRITE_SOME_COLUMNS{

        @Override
        public PartitionStatistics updatePartitionStatistics(PartitionStatistics oldPartitionStats, PartitionStatistics newPartitionStats) {
            HashMap<String, HiveColumnStatistics> allColumnStatists = new HashMap<String, HiveColumnStatistics>(oldPartitionStats.getColumnStatistics());
            allColumnStatists.putAll(newPartitionStats.getColumnStatistics());
            return new PartitionStatistics(newPartitionStats.getBasicStatistics(), allColumnStatists);
        }
    }
    ,
    MERGE_INCREMENTAL{

        @Override
        public PartitionStatistics updatePartitionStatistics(PartitionStatistics oldPartitionStats, PartitionStatistics newPartitionStats) {
            return StatisticsUpdateMode.addIncrementalStatistics(oldPartitionStats, newPartitionStats);
        }
    }
    ,
    UNDO_MERGE_INCREMENTAL{

        @Override
        public PartitionStatistics updatePartitionStatistics(PartitionStatistics oldPartitionStats, PartitionStatistics newPartitionStats) {
            HiveBasicStatistics newTableStatistics = StatisticsUpdateMode.reduce(oldPartitionStats.getBasicStatistics(), newPartitionStats.getBasicStatistics(), Operator.SUBTRACT);
            return new PartitionStatistics(newTableStatistics, (Map<String, HiveColumnStatistics>)ImmutableMap.of());
        }
    }
    ,
    CLEAR_ALL{

        @Override
        public PartitionStatistics updatePartitionStatistics(PartitionStatistics oldPartitionStats, PartitionStatistics newPartitionStats) {
            return PartitionStatistics.empty();
        }
    };


    public abstract PartitionStatistics updatePartitionStatistics(PartitionStatistics var1, PartitionStatistics var2);

    private static PartitionStatistics addIncrementalStatistics(PartitionStatistics existingStatistics, PartitionStatistics incrementalStatistics) {
        if (existingStatistics.getBasicStatistics().getRowCount().isPresent() && existingStatistics.getBasicStatistics().getRowCount().getAsLong() == 0L) {
            return incrementalStatistics;
        }
        if (incrementalStatistics.getBasicStatistics().getRowCount().isPresent() && incrementalStatistics.getBasicStatistics().getRowCount().getAsLong() == 0L) {
            return existingStatistics;
        }
        HiveBasicStatistics mergedTableStatistics = StatisticsUpdateMode.reduce(existingStatistics.getBasicStatistics(), incrementalStatistics.getBasicStatistics(), Operator.ADD);
        ImmutableMap mergedColumnStatistics = (ImmutableMap)Sets.intersection(existingStatistics.getColumnStatistics().keySet(), incrementalStatistics.getColumnStatistics().keySet()).stream().collect(ImmutableMap.toImmutableMap(column -> column, column -> StatisticsUpdateMode.merge(column, existingStatistics, incrementalStatistics)));
        return new PartitionStatistics(mergedTableStatistics, (Map<String, HiveColumnStatistics>)mergedColumnStatistics);
    }

    private static HiveBasicStatistics reduce(HiveBasicStatistics first, HiveBasicStatistics second, Operator operator) {
        return new HiveBasicStatistics(StatisticsUpdateMode.reduce(first.getFileCount(), second.getFileCount(), operator, false), StatisticsUpdateMode.reduce(first.getRowCount(), second.getRowCount(), operator, false), StatisticsUpdateMode.reduce(first.getInMemoryDataSizeInBytes(), second.getInMemoryDataSizeInBytes(), operator, false), StatisticsUpdateMode.reduce(first.getOnDiskDataSizeInBytes(), second.getOnDiskDataSizeInBytes(), operator, false));
    }

    private static HiveColumnStatistics merge(String column, PartitionStatistics firstStats, PartitionStatistics secondStats) {
        HiveColumnStatistics first = firstStats.getColumnStatistics().get(column);
        HiveColumnStatistics second = secondStats.getColumnStatistics().get(column);
        return new HiveColumnStatistics(StatisticsUpdateMode.mergeIntegerStatistics(first.getIntegerStatistics(), second.getIntegerStatistics()), StatisticsUpdateMode.mergeDoubleStatistics(first.getDoubleStatistics(), second.getDoubleStatistics()), StatisticsUpdateMode.mergeDecimalStatistics(first.getDecimalStatistics(), second.getDecimalStatistics()), StatisticsUpdateMode.mergeDateStatistics(first.getDateStatistics(), second.getDateStatistics()), StatisticsUpdateMode.mergeBooleanStatistics(first.getBooleanStatistics(), second.getBooleanStatistics()), StatisticsUpdateMode.reduce(first.getMaxValueSizeInBytes(), second.getMaxValueSizeInBytes(), Operator.MAX, true), StatisticsUpdateMode.mergeAverageColumnLength(column, firstStats, secondStats), StatisticsUpdateMode.reduce(first.getNullsCount(), second.getNullsCount(), Operator.ADD, false), StatisticsUpdateMode.mergeDistinctValueCount(column, firstStats, secondStats));
    }

    private static OptionalLong mergeDistinctValueCount(String column, PartitionStatistics first, PartitionStatistics second) {
        HiveColumnStatistics firstColumn = first.getColumnStatistics().get(column);
        HiveColumnStatistics secondColumn = second.getColumnStatistics().get(column);
        OptionalLong firstDistinct = firstColumn.getDistinctValuesWithNullCount();
        OptionalLong secondDistinct = secondColumn.getDistinctValuesWithNullCount();
        if (firstDistinct.isPresent() && StatisticsUpdateMode.noNulls(firstColumn) && StatisticsUpdateMode.isAllNull(second, secondColumn)) {
            return OptionalLong.of(firstDistinct.getAsLong() + 1L);
        }
        if (secondDistinct.isPresent() && StatisticsUpdateMode.noNulls(secondColumn) && StatisticsUpdateMode.isAllNull(first, firstColumn)) {
            return OptionalLong.of(secondDistinct.getAsLong() + 1L);
        }
        if (firstDistinct.isPresent() && secondDistinct.isPresent()) {
            return OptionalLong.of(StatisticsUpdateMode.max(firstDistinct.getAsLong(), secondDistinct.getAsLong()));
        }
        return OptionalLong.empty();
    }

    private static boolean noNulls(HiveColumnStatistics columnStats) {
        if (columnStats.getNullsCount().isEmpty()) {
            return false;
        }
        return columnStats.getNullsCount().orElse(-1L) == 0L;
    }

    private static boolean isAllNull(PartitionStatistics stats, HiveColumnStatistics columnStats) {
        if (stats.getBasicStatistics().getRowCount().isEmpty() || columnStats.getNullsCount().isEmpty()) {
            return false;
        }
        return stats.getBasicStatistics().getRowCount().getAsLong() == columnStats.getNullsCount().getAsLong();
    }

    private static OptionalDouble mergeAverageColumnLength(String column, PartitionStatistics first, PartitionStatistics second) {
        if (first.getBasicStatistics().getRowCount().isEmpty() || second.getBasicStatistics().getRowCount().isEmpty()) {
            return OptionalDouble.empty();
        }
        long firstRowCount = first.getBasicStatistics().getRowCount().getAsLong();
        long secondRowCount = second.getBasicStatistics().getRowCount().getAsLong();
        HiveColumnStatistics firstColumn = first.getColumnStatistics().get(column);
        HiveColumnStatistics secondColumn = second.getColumnStatistics().get(column);
        if (firstRowCount == firstColumn.getNullsCount().orElse(0L)) {
            return secondColumn.getAverageColumnLength();
        }
        if (secondRowCount == secondColumn.getNullsCount().orElse(0L)) {
            return firstColumn.getAverageColumnLength();
        }
        if (firstColumn.getAverageColumnLength().isEmpty() || secondColumn.getAverageColumnLength().isEmpty()) {
            return OptionalDouble.empty();
        }
        long firstNonNullRowCount = firstRowCount - firstColumn.getNullsCount().orElse(0L);
        long secondNonNullRowCount = secondRowCount - secondColumn.getNullsCount().orElse(0L);
        double firstTotalSize = firstColumn.getAverageColumnLength().getAsDouble() * (double)firstNonNullRowCount;
        double secondTotalSize = secondColumn.getAverageColumnLength().getAsDouble() * (double)secondNonNullRowCount;
        return OptionalDouble.of((firstTotalSize + secondTotalSize) / (double)(firstNonNullRowCount + secondNonNullRowCount));
    }

    private static Optional<IntegerStatistics> mergeIntegerStatistics(Optional<IntegerStatistics> first, Optional<IntegerStatistics> second) {
        if (first.isPresent() && second.isPresent()) {
            return Optional.of(new IntegerStatistics(StatisticsUpdateMode.reduce(first.get().getMin(), second.get().getMin(), Operator.MIN, true), StatisticsUpdateMode.reduce(first.get().getMax(), second.get().getMax(), Operator.MAX, true)));
        }
        return Optional.empty();
    }

    private static Optional<DoubleStatistics> mergeDoubleStatistics(Optional<DoubleStatistics> first, Optional<DoubleStatistics> second) {
        if (first.isPresent() && second.isPresent()) {
            return Optional.of(new DoubleStatistics(StatisticsUpdateMode.reduce(first.get().getMin(), second.get().getMin(), Operator.MIN, true), StatisticsUpdateMode.reduce(first.get().getMax(), second.get().getMax(), Operator.MAX, true)));
        }
        return Optional.empty();
    }

    private static Optional<DecimalStatistics> mergeDecimalStatistics(Optional<DecimalStatistics> first, Optional<DecimalStatistics> second) {
        if (first.isPresent() && second.isPresent()) {
            return Optional.of(new DecimalStatistics(StatisticsUpdateMode.mergeComparable(first.get().getMin(), second.get().getMin(), Operator.MIN), StatisticsUpdateMode.mergeComparable(first.get().getMax(), second.get().getMax(), Operator.MAX)));
        }
        return Optional.empty();
    }

    private static Optional<DateStatistics> mergeDateStatistics(Optional<DateStatistics> first, Optional<DateStatistics> second) {
        if (first.isPresent() && second.isPresent()) {
            return Optional.of(new DateStatistics(StatisticsUpdateMode.mergeComparable(first.get().getMin(), second.get().getMin(), Operator.MIN), StatisticsUpdateMode.mergeComparable(first.get().getMax(), second.get().getMax(), Operator.MAX)));
        }
        return Optional.empty();
    }

    private static Optional<BooleanStatistics> mergeBooleanStatistics(Optional<BooleanStatistics> first, Optional<BooleanStatistics> second) {
        if (first.isPresent() && second.isPresent()) {
            return Optional.of(new BooleanStatistics(StatisticsUpdateMode.reduce(first.get().getTrueCount(), second.get().getTrueCount(), Operator.ADD, false), StatisticsUpdateMode.reduce(first.get().getFalseCount(), second.get().getFalseCount(), Operator.ADD, false)));
        }
        return Optional.empty();
    }

    private static OptionalLong reduce(OptionalLong first, OptionalLong second, Operator operator, boolean returnFirstNonEmpty) {
        if (first.isPresent() && second.isPresent()) {
            return switch (operator.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> OptionalLong.of(first.getAsLong() + second.getAsLong());
                case 1 -> OptionalLong.of(first.getAsLong() - second.getAsLong());
                case 3 -> OptionalLong.of(StatisticsUpdateMode.max(first.getAsLong(), second.getAsLong()));
                case 2 -> OptionalLong.of(StatisticsUpdateMode.min(first.getAsLong(), second.getAsLong()));
            };
        }
        if (returnFirstNonEmpty) {
            return first.isPresent() ? first : second;
        }
        return OptionalLong.empty();
    }

    private static OptionalDouble reduce(OptionalDouble first, OptionalDouble second, Operator operator, boolean returnFirstNonEmpty) {
        if (first.isPresent() && second.isPresent()) {
            return switch (operator.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> OptionalDouble.of(first.getAsDouble() + second.getAsDouble());
                case 1 -> OptionalDouble.of(first.getAsDouble() - second.getAsDouble());
                case 3 -> OptionalDouble.of(StatisticsUpdateMode.max(first.getAsDouble(), second.getAsDouble()));
                case 2 -> OptionalDouble.of(StatisticsUpdateMode.min(first.getAsDouble(), second.getAsDouble()));
            };
        }
        if (returnFirstNonEmpty) {
            return first.isPresent() ? first : second;
        }
        return OptionalDouble.empty();
    }

    private static <T extends Comparable<? super T>> Optional<T> mergeComparable(Optional<T> first, Optional<T> second, Operator operator) {
        if (first.isPresent() && second.isPresent()) {
            return switch (operator.ordinal()) {
                case 3 -> Optional.of(StatisticsUpdateMode.max((Comparable)first.get(), (Comparable)second.get()));
                case 2 -> Optional.of(StatisticsUpdateMode.min((Comparable)first.get(), (Comparable)second.get()));
                default -> throw new IllegalArgumentException("Unexpected operator: " + String.valueOf((Object)operator));
            };
        }
        return first.isPresent() ? first : second;
    }

    private static <T extends Comparable<? super T>> T max(T first, T second) {
        return first.compareTo(second) >= 0 ? first : second;
    }

    private static <T extends Comparable<? super T>> T min(T first, T second) {
        return first.compareTo(second) <= 0 ? first : second;
    }

    private static enum Operator {
        ADD,
        SUBTRACT,
        MIN,
        MAX;

    }
}

